# coding=utf-8

from sandbox.projects.market.ff_wf_api.loadTesting.retrying_http_service import post_for_json


class Constants:

    def __init__(self):
        pass

    CART_URL = '%s/cart?showHiddenPaymentOptions=true&uid=851268023&allowPrepaidForNoAuth=1&rgb=BLUE'
    CART_BODY = '{"buyerRegionId":213,"isBooked":false,"buyerCurrency":"RUR","paymentType":"POSTPAID",' \
                '"paymentMethod":"CASH_ON_DELIVERY","carts":[{"shopId":431782,"items":[{"feedId":%d,"offerId":"%s",' \
                '"buyerPrice":%s,"count":%d,"showInfo":"%s","wareMd5":"%s","weight":1,"width":"1","height":"1",' \
                '"depth":"1","widthAsLong":1,"heightAsLong":1,"depthAsLong":1}],"delivery":{"regionId":213}}]}'
    CHECKOUT_URL = '/checkout?showHiddenPaymentOptions=true&uid=851268023&allowPrepaidForNoAuth=1&rgb=BLUE'
    CHECKOUT_BODY = '{"buyerRegionId":213,"isBooked":false,"buyerCurrency":"RUR","paymentType":"POSTPAID",' \
                    '"paymentMethod":"CASH_ON_DELIVERY","orders":[{"shopId":431782,"items":[{"feedId":%d,' \
                    '"offerId":"%s","buyerPrice":%s,"count":%d,"showInfo":"%s","wareMd5":"%s","weight":1,"width":"1",' \
                    '"height":"1","depth":"1","widthAsLong":1,"heightAsLong":1,"depthAsLong":1}],' \
                    '"delivery":{"hash":"%s","outletId":%d,"regionId":%d}}],' \
                    '"buyer":{"lastName":"lastName","firstName":"firstName","middleName":"middleName",' \
                    '"phone":"+77777777777","email":"ymail@y.mail","ip":"8.8.8.8","dontCall":true,' \
                    '"uuid":"2af28f3ab6cc3b47864976b2dac27b46"}}'
    HEADERS = {'Content-Type': 'application/json', 'X-Hit-Rate-Group': 'UNLIMIT', 'IgnoreTvmCheck': 'true'}


def cart(checkouter_url, item_info):
    body = Constants.CART_BODY % (
        item_info[0], item_info[1], str(item_info[2]), item_info[3], item_info[4], item_info[5])
    carts_content = post_for_json(Constants.CART_URL % checkouter_url, body, Constants.HEADERS).get('carts')
    shop_cart = None
    for cart in carts_content:
        if cart.get('shopId') == 431782:
            shop_cart = cart
    if not shop_cart:
        raise ValueError('Cart with shop id 431782 not found')
    delivery_options = shop_cart.get('deliveryOptions')
    if not delivery_options:
        raise ValueError('Delivery options not found')
    ds_delivery_options = None
    for delivery_option in delivery_options:
        if delivery_option.get('deliveryServiceId') == 107 and delivery_option.get('type') == 'PICKUP':
            payment_options = delivery_option.get('paymentOptions')
            has_postpaid_option = False
            for payment_option in payment_options:
                payment_method = payment_option.get('paymentMethod')
                if payment_option.get('paymentType') == 'POSTPAID' and payment_method == 'CASH_ON_DELIVERY':
                    has_postpaid_option = True
            if has_postpaid_option:
                ds_delivery_options = delivery_option
                break
    if not ds_delivery_options:
        raise ValueError('Delivery options for Pickpoint not found')
    delivery_hash = ds_delivery_options.get('hash')
    if not delivery_hash:
        raise ValueError('Delivery hash not found')
    outlets = ds_delivery_options.get('outlets')
    if not outlets:
        raise ValueError('Outlets not found')
    outlet_id = outlets[0].get('id')
    offer_item = None
    items = shop_cart.get('items')
    for item in items:
        if item.get('offerId') == item_info[1]:
            offer_item = item
    if not offer_item:
        raise ValueError('Offer item not found')
    buyer_price_nominal = offer_item.get('buyerPriceNominal')
    return delivery_hash, outlet_id, 213, item_info, buyer_price_nominal


def make_checkout_request(delivery_info):
    delivery_hash = delivery_info[0]
    outlet_id = delivery_info[1]
    region_id = delivery_info[2]
    item_info = delivery_info[3]
    price = delivery_info[4]
    body = Constants.CHECKOUT_BODY % \
           (item_info[0], item_info[1], str(price), item_info[3], item_info[4], item_info[5], delivery_hash,
            outlet_id, region_id)
    return Constants.CHECKOUT_URL, body, ['X-Hit-Rate-Group: UNLIMIT']
