# coding=utf-8

from sandbox.projects.market.ff_wf_api.loadTesting.retrying_http_service import get_json


class Constants:

    def __init__(self):
        pass

    GET_OFFER_URL = '%s/yandsearch?ip=127.0.0.1&place=offerinfo&feed_shoffer_id=475690-200423152.100126176155&' \
                    'fesh=431782&rids=213&regset=1&pp=18&show-booking-outlets=0&adult=0&numdoc=100&' \
                    'show-model-card-params=1&showdiscounts=1&cpa-category-filter=0&strip_query_language=0&' \
                    'show-promoted=1&show-min-quantity=1&show-urls=decrypted&client=ckeckout&' \
                    'co-from=checkouter&show-filter-mark=specifiedForOffer&rgb=BLUE&show-preorder=0'


def get_crossdock_offer(report_url):
    offers_json = get_json(Constants.GET_OFFER_URL % report_url)
    offer_element = None
    results = offers_json.get('search').get('results')
    for offer in results:
        weight = offer.get('weight')
        dimensions = offer.get('dimensions')
        if 0 < float(weight) < 10 and 0 < float(dimensions[0]) < 50 and 0 < float(dimensions[1]) < 50 and 0 < float(dimensions[2]) < 50:
            offer_element = offer
    if not offer_element:
        raise RuntimeError('Correct offer not found in report')
    feed_id = 475690
    offer_id = offer_element.get('shop').get('feed').get('offerId')
    buyer_price = float(offer_element.get('prices').get('value'))
    count = 1
    show_info = offer_element.get('feeShow')
    ware_md5 = offer_element.get('wareId')
    return feed_id, offer_id, buyer_price, count, show_info, ware_md5
