# coding=utf-8

import codecs
import random

from sandbox import sdk2

from create_inbound_ammos_list_generator import generate_ammos_list
from create_inbound_skus_filter import get_skus_for_create_inbound
from sandbox.projects.market.ff_wf_api import FulfillmentWorkflowCreateInboundAmmo


class CreateInboundGenerator(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        ffwf_url = sdk2.parameters.String('FFWF Url', required=True, default='http://ffw-api.tst.vs.market.yandex.net')
        items_in_inbounds = sdk2.parameters.Integer('Items in inbounds except one with all items', default=80)
        number_of_distinct_inbounds = sdk2.parameters.Integer('Number of distinct inbounds', default=20)

    class Requirements(sdk2.Requirements):
        disk_space = 1024 * 5

    def on_execute(self):
        skus_for_create_1p_inbound = get_skus_for_create_inbound(self.Parameters.ffwf_url, True)
        skus_for_create_3p_inbound = get_skus_for_create_inbound(self.Parameters.ffwf_url, False)
        generated_ammos = generate_ammos_list(self.Parameters.ffwf_url, self.Parameters.items_in_inbounds,
                                              self.Parameters.number_of_distinct_inbounds,
                                              skus_for_create_1p_inbound, skus_for_create_3p_inbound)

        random.shuffle(generated_ammos)
        generated_ammo = ''
        for ammo in generated_ammos:
            generated_ammo += ammo

        data = sdk2.ResourceData(FulfillmentWorkflowCreateInboundAmmo(self,
                                                                      'Fulfillment workflow create inbound ammo',
                                                                      'ffwf_create_inbound_ammo.txt'))
        with codecs.open('ffwf_create_inbound_ammo.txt', 'w', encoding='utf-8') as f:
            f.write(generated_ammo)
        data.ready()
