# coding=utf-8

import random

from create_inbound_body_generator import generate_body
from sandbox.projects.market.ff_wf_api.loadTesting.ammo_generator import make_ammo


def generate_ammos_list(ffwf_url, items_in_inbounds, number_of_distinct_inbounds,
                        skus_for_create_1p_inbound, skus_for_create_3p_inbound,
                        existing_tags=None):
    generated_ammos = []
    generated_ammos.extend(generate_ammos(ffwf_url, items_in_inbounds, number_of_distinct_inbounds,
                                          '/upload-request/supply', 'create1pSupplyWithRequiredCalendaring', 0,
                                          skus_for_create_1p_inbound, 10264169, False, False, existing_tags))
    generated_ammos.extend(generate_ammos(ffwf_url, items_in_inbounds, number_of_distinct_inbounds,
                                          '/upload-request/supply', 'create3pSupplyWithRequiredCalendaring', 0,
                                          skus_for_create_3p_inbound, 10296179, False, False, existing_tags))
    generated_ammos.extend(generate_ammos(ffwf_url, items_in_inbounds, number_of_distinct_inbounds,
                                          '/upload-request/supply', 'create1pSupplyWithoutCalendaring', 1,
                                          skus_for_create_1p_inbound, 10264169, False, False, existing_tags))
    generated_ammos.extend(generate_ammos(ffwf_url, items_in_inbounds, number_of_distinct_inbounds,
                                          '/upload-request/supply', 'create3pSupplyWithoutCalendaring', 1,
                                          skus_for_create_3p_inbound, 10296179, False, False,  existing_tags))
    generated_ammos.extend(generate_ammos(ffwf_url, items_in_inbounds, number_of_distinct_inbounds,
                                          '/upload-request/supply', 'create3pSupplyNeedConfirmation', 1,
                                          skus_for_create_3p_inbound, 10296179, False, True, existing_tags))
    generated_ammos.extend(generate_ammos(ffwf_url, items_in_inbounds, number_of_distinct_inbounds,
                                          '/upload-request/supply', 'create1pSupplyWithAutoCalendaring', 2,
                                          skus_for_create_1p_inbound, 10264169, False, False, existing_tags))
    generated_ammos.extend(generate_ammos(ffwf_url, items_in_inbounds, number_of_distinct_inbounds,
                                          '/upload-request/supply', 'create3pSupplyWithAutoCalendaring', 2,
                                          skus_for_create_3p_inbound, 10296179, False, False,  existing_tags))
    generated_ammos.extend(generate_ammos(ffwf_url, items_in_inbounds, number_of_distinct_inbounds,
                                          '/upload-request/shadow-supply', 'create3pShadowSupply', 0,
                                          skus_for_create_3p_inbound, 10296179, True, False,  existing_tags))
    return generated_ammos


def generate_ammos(ffwf_url, items_in_inbounds, number_of_distinct_inbounds,
                   url, tag, calendaring_mode, skus_for_create_inbound, supplier_id, is_shadow, need_confirmation,
                   existing_tags=None):
    if len(skus_for_create_inbound) == 0:
        return []
    if existing_tags:
        existing_tags.add(tag)
    generated_ammos = [make_ammo(ffwf_url, 'POST', url, tag,
                                 generate_body(skus_for_create_inbound, calendaring_mode, supplier_id,
                                               is_shadow, need_confirmation))]
    if len(skus_for_create_inbound) < int(items_in_inbounds):
        return generated_ammos
    for i in range(int(number_of_distinct_inbounds)):
        current_skus = random.sample(skus_for_create_inbound, items_in_inbounds)
        generated_ammos.append(make_ammo(ffwf_url, 'POST', url, tag,
                                         generate_body(current_skus, calendaring_mode, supplier_id,
                                                       is_shadow, need_confirmation)))
    return generated_ammos
