# coding=utf-8
from datetime import datetime, timedelta
from sandbox.projects.market.ff_wf_api.loadTesting.constants import Constants


class Constants:
    INBOUND_TEMPLATE = '{"date":"%s","supplierId":%d,"serviceId":' + Constants.WAREHOUSE + ',"type":999999,"externalOperationType":7,' \
                                                                                           '"externalRequestId":"LOAD_1","calendaringMode":%d,"needConfirmation":%s,"items":[%s]}'
    SHADOW_3P_INBOUND_TEMPLATE = '{"supplierId":%d,"serviceId":' + Constants.WAREHOUSE + ',"type":8,"externalOperationType":7,' \
                                                                                         '"externalRequestId":"LOAD_1","calendaringMode":%d,"needConfirmation":%s,"items":[%s]}'
    ITEM_TEMPLATE = '{"article":"%s","name":"LOAD","barcodes":["4607004650127"],"price":110.5,"count":3,"vatRate":1}'


def generate_body(skus, calendaring_mode, supplier_id, is_shadow_3p, need_confirmation=False):
    items = ''
    i = 0
    for sku in skus:
        if i != 0:
            items += ','
        item = Constants.ITEM_TEMPLATE % sku
        items += item
        i += 1
    now = datetime.now()
    inbound_time = now + timedelta(days=1) - timedelta(microseconds=now.microsecond)
    now_string = datetime.isoformat(inbound_time) + '+03:00'
    if is_shadow_3p:
        return Constants.SHADOW_3P_INBOUND_TEMPLATE % (
            supplier_id, calendaring_mode, str(need_confirmation).lower(), items)
    return Constants.INBOUND_TEMPLATE % (
        now_string, supplier_id, calendaring_mode, str(need_confirmation).lower(), items)
