# coding=utf-8
from datetime import datetime, timedelta


class Constants:
    WITHDRAWS_TEMPLATE = '''
    {
        "date": "%s",
        "supplierId": %d,
        "comment": "some comment",
        "type": 11,
        "externalRequestId": "2341431",
        "logisticsPointId": 12341
    }'''


def generate_body(supplier_id):
    now = datetime.now()
    inbound_time = now + timedelta(days=1) - timedelta(microseconds=now.microsecond)
    now_string = datetime.isoformat(inbound_time) + '+03:00'
    return Constants.WITHDRAWS_TEMPLATE % (now_string, supplier_id)
