# coding=utf-8

import requests
import logging
import json


def get_json(url):
    for i in range(0, 3):
        logging.info('Sending get request to ' + url)
        response = requests.get(url)
        logging.info('Got response with code ' + str(response.status_code) + ' and body ' + response.content)
        if response.status_code == 200:
            return json.loads(response.content)
    raise Exception('Failed to get from url ' + url)


def post_for_json(url, body, headers=None):
    for i in range(0, 3):
        logging.info('Sending get request to ' + url + ' with body ' + body)
        send_headers = {'Content-Type': 'application/json'}
        if headers is not None:
            send_headers = headers
        response = requests.post(url, data=body, headers=send_headers)
        logging.info('Got response with code ' + str(response.status_code) + ' and body ' + response.content)
        if response.status_code == 200:
            return json.loads(response.content)
    raise Exception('Failed to get from url ' + url)
