# coding=utf-8
import logging
from sandbox import sdk2

logger = logging.getLogger(__name__)


def create_metrics_params():
    class MetricsParameters(sdk2.Task.Parameters):
        with sdk2.parameters.Group('Metrics') as metrics_block:
            logbroker_endpoint = sdk2.parameters.String(
                'Хост логброкера для записи статистики',
                default="logbroker.yandex.net",
            )
            logbroker_port = sdk2.parameters.Integer(
                'Порт логброкера для записи статистики',
                default=2135,
            )
            logbroker_topic = sdk2.parameters.String(
                'Топик логброкера для записи статистики',
                default="market-front-infra/stable/autotest-stats",
            )
            logbroker_errors_topic = sdk2.parameters.String(
                'Топик логброкера для записи ошибок',
                default="market-front-infra/market-infra-error-booster",
            )
            # logbroker_oauth = sdk2.parameters.YavSecret(
            #     "OAuth для похода в логброкер",
            #     default="sec-01fpz25amdjbmq1m0j1ts83f6w"
            # )
            logbroker_oauth = sdk2.parameters.Vault(
                "OAuth для похода в логброкер",
                default="market_autotests_logborker_oauth"
            )

    return MetricsParameters


def select_metrics_parameters(taskParameters):
    return {
        'logbroker_endpoint': taskParameters.logbroker_endpoint,
        'logbroker_port': taskParameters.logbroker_port,
        'logbroker_topic': taskParameters.logbroker_topic,
        'logbroker_errors_topic': taskParameters.logbroker_errors_topic,
        'logbroker_oauth': taskParameters.logbroker_oauth,
    }
