# -*- coding: utf-8 -*-

"""
Кастомный конфиг который переопределяет значения, лежащие в репозитории фронтов.
ПРИМЕР
Все поля ниже - не обязательные.
"dsk_new-search": {                                     # Фронтовый флаг для переопределения конфига. Без равно! "dsk_new-search=test-default" не будет работать.
    "description": "Новая выдача Скорости в десктопе",  # Если хочется заменить описание которое поставил разрабушка на понятное вам.
    "issue_key": "MARKETFRONT-63925",                   # Если разработчик указал неправильный тикет и нужно поменять номер тикета
    "qa": "@lengl",                                     # Если в тикете указан QA, но его в тикете поменять нельзя, а звать надо другого.
    "mute": True,                                       # Поставить True, если вообще не надо призывать QA на этот эксперимент
},                                                      # Обязательно оставляйте запятую в конце.
"""
CUSTOM_CONFIG = {
    # Пример для копипасты, оставляйте нужные поля и меняйте значения на нужные вам.
    "all_template_new_search": {
        "description": "Новая выдача Скорости в десктопе",
        "issue_key": "MARKETFRONT-63925",
        "qa": "@lengl",
        "mute": True,
    },
    "all_daily-bonuses-popup_hide": {
        "issue_key": "MARKETFRONT-65506",
    },
    "dsk_profit-index": {
        "issue_key": "MARKETFRONT-62617",
    },
    "touch_profit-index": {
        "issue_key": "MARKETFRONT-62617",
    },
    "touch_profit-index-new-snippets": {
        "issue_key": "MARKETFRONT-62617",
    },
    "touch_profit-index-entry": {
        "issue_key": "MARKETFRONT-62617",
    },
    "all_thank-you-page_redesign": {
        "issue_key": "MARKETFRONT-64570",
    },
    "dsk_new-search": {
        "issue_key": "MARKETFRONT-63925",
    },
    "all_checkout_new_intervals": {
        "issue_key": "MARKETFRONT-59363",
    },
    "touch_km-user-photo_position": {
        "issue_key": "MARKETFRONT-65113",
    },
    "all_bnpl": {
        "issue_key": "MARKETFRONT-54369",
    },
    "touch_turboapp-express-menu-entrypoint-ios": {
        "issue_key": "MARKETFRONT-63398",
    },
    "touch_search-global-redesign": {
        "issue_key": "MARKETFRONT-49987",
    },
    "touch_reverse_search_snippet_jumptable_params": {
        "issue_key": "MARKETFRONT-65216",
    },
    "all_checkout_pickup-cashback": {
        "issue_key": "MARKETFRONT-57380",
    },

    # ------------------------------------------
    # ^ Новые конфиги закидывать НАД ЭТОЙ ЧЕРТОЙ (просто на всякий случай)
}
