# coding=utf-8

from sandbox.projects.market.front.MarketFrontBuildPlatformNode import MarketFrontBuildPlatformNode
from sandbox.projects.market.front.helpers.startrack import FixVersion
from sandbox.projects.market.resources import MARKET_FRONT_API
from sandbox import sdk2


class MarketFrontBuildBlueApiNode(MarketFrontBuildPlatformNode):
    """
    Task to build Front API node application
    """

    # todo: remove this
    #  @see: https://st.yandex-team.ru/MARKETFRONTECH-506
    #  This build is always "platform"-build
    @property
    def _app_repo(self):
        return "https://github.yandex-team.ru/market/marketfront.git"

    @property
    def resource_type(self):
        return MARKET_FRONT_API

    class Parameters(MarketFrontBuildPlatformNode.Parameters):
        copy_static = sdk2.parameters.Bool("Копировать фриз статики в приложение", required=True, default=False)
        upload_static_to_s3 = sdk2.parameters.Bool("Загружать статику в s3", required=True, default=False)
        build_static = sdk2.parameters.Bool("Проводить сборку статического пакета", required=True, default=False)

        with build_static.value[True]:
            fix_version = FixVersion("Фикс-версия релиза в формате YYYY.R.PS", required=True)

        with MarketFrontBuildPlatformNode.Parameters.app() as app:
            app_platform = sdk2.parameters.String("Платформа приложения", required=True, default_value="api")
