# coding=utf-8

from sandbox.projects.market.front.MarketFrontBuildPlatformNode import MarketFrontBuildPlatformNode
from sandbox.projects.market.front.helpers.sandbox_helpers import NotPlatformBuildError
from sandbox.projects.market.resources import MARKET_BLUETOUCH_FRONT
from sandbox import sdk2


class MarketFrontBuildBlueTouchNode(MarketFrontBuildPlatformNode):
    """
    Task to build market blue touch node application
    """

    # todo: remove this
    #  @see: https://st.yandex-team.ru/MARKETFRONTECH-506
    #  This build is always "platform"-build
    @property
    def _app_repo(self):
        raise NotPlatformBuildError('Only platform build allowed for this task; check if "platform" param is specified')

    @property
    def static_root(self):
        return "market-bluetouch/_"

    @property
    def resource_type(self):
        return MARKET_BLUETOUCH_FRONT

    @property
    def static_package_name(self):
        return "yandex-market-bluetouch-static"

    class Parameters(MarketFrontBuildPlatformNode.Parameters):
        with MarketFrontBuildPlatformNode.Parameters.app() as app:
            app_platform = sdk2.parameters.String("Платформа приложения", required=True, default_value="touch")
