# coding=utf-8

from sandbox.projects.market.front.MarketFrontBuildPlatformNode import MarketFrontBuildPlatformNode
from sandbox.projects.market.front.resources import MARKET_CORPSITE_WEB_FRONT
from sandbox import sdk2


class MarketFrontBuildCorpSiteWeb(MarketFrontBuildPlatformNode):
    """
    Task to build market corpSite application
    """

    @property
    def app_repo(self):
        return "https://github.yandex-team.ru/market/marketcorp.git"

    @property
    def resource_type(self):
        return MARKET_CORPSITE_WEB_FRONT

    # Проперти пустые, т.к. сервис работает только через yastat + s3
    @property
    def static_package_name(self):
        return

    @property
    def static_root(self):
        return "market-corpsite"

    @property
    def make_env(self):
        env = super(MarketFrontBuildPlatformNode, self).make_env
        if self.is_platform_build:
            env.update({"APP_PLATFORM": self.platform})
        return env

    class Parameters(MarketFrontBuildPlatformNode.Parameters):
        with MarketFrontBuildPlatformNode.Parameters.app() as app:
            app_platform = sdk2.parameters.String("Платформа приложения", required=True, default_value="desktop")
