# coding=utf-8

from sandbox.projects.market.front.MarketFrontNodejsBuildAbstract import MarketFrontNodejsBuildAbstract
from sandbox.projects.market.resources import MARKET_VENDORS_FRONT_APP

from sandbox import sdk2


class MarketFrontBuildVendors(MarketFrontNodejsBuildAbstract):
    """
    Task to build market vendors node application
    """

    @property
    def app_repo(self):
        return "https://github.yandex-team.ru/market/vendors.git"

    @property
    def static_root(self):
        return "market-vendors/_"

    @property
    def resource_type(self):
        return MARKET_VENDORS_FRONT_APP

    @property
    def static_package_name(self):
        return "yandex-market-vendors-static"

    class Parameters(MarketFrontNodejsBuildAbstract.Parameters):
        with sdk2.parameters.Group("Вендора") as vendor:
            vendor_branch = sdk2.parameters.String(
                "Ветка репозитория vendor-libs",
                default_value="",
                required=False
            )

        with sdk2.parameters.Group("common") as common:
            common_branch = sdk2.parameters.String(
                "Ветка репозитория common",
                default_value="",
                required=False
            )
