# coding=utf-8

from sandbox.projects.market.front.MarketFrontBuildPlatformNode import MarketFrontBuildPlatformNode
from sandbox.projects.market.resources import MARKET_DESKTOP_FRONT

from sandbox import sdk2


class MarketFrontBuildWhiteDesktopNode(MarketFrontBuildPlatformNode):
    """
    Task to build market white desktop node application
    """

    @property
    def app_repo(self):
        return "https://github.yandex-team.ru/market/marketfront.git"

    @property
    def static_root(self):
        return "market-skubi/_"

    @property
    def resource_type(self):
        return MARKET_DESKTOP_FRONT

    @property
    def static_package_name(self):
        return "yandex-market-skubi-static"

    @property
    def make_env(self):
        env = super(MarketFrontBuildPlatformNode, self).make_env
        if self.is_platform_build:
            env.update({"APP_PLATFORM": self.platform, "REAL_CORE": "1"})
        return env

    class Parameters(MarketFrontBuildPlatformNode.Parameters):
        with MarketFrontBuildPlatformNode.Parameters.app() as app:
            app_platform = sdk2.parameters.String("Платформа приложения", required=True, default_value="desktop")
