# coding=utf-8

from sandbox.projects.market.front.MarketFrontBuildPlatformNode import MarketFrontBuildPlatformNode
from sandbox.projects.market.resources import MARKET_TOUCH_FRONT

from sandbox import sdk2


class MarketFrontBuildWhiteTouchNode(MarketFrontBuildPlatformNode):
    """
    Task to build market white touch node application
    """

    @property
    def app_repo(self):
        return "https://github.yandex-team.ru/market/marketfront.git"

    @property
    def static_root(self):
        return "market-touch/_"

    @property
    def resource_type(self):
        return MARKET_TOUCH_FRONT

    @property
    def static_package_name(self):
        return "yandex-market-touch-static"

    @property
    def make_env(self):
        env = super(MarketFrontBuildPlatformNode, self).make_env
        if self.is_platform_build:
            env.update({"APP_PLATFORM": self.platform, "REAL_CORE": "1"})
        return env

    class Parameters(MarketFrontBuildPlatformNode.Parameters):
        with MarketFrontBuildPlatformNode.Parameters.app() as app:
            app_platform = sdk2.parameters.String("Платформа приложения", required=True, default_value="touch")
