# coding=utf-8

from helpers import CheckExecutionError


def check_duplicates_in_dependencies(package_json):
    # Проверяет дубликаты пакетов в dependencies и devDependencies

    dependencies_packages = set(package_json['dependencies'].keys())
    dev_dependencies_packages = set(package_json['devDependencies'].keys())
    duplicated_packages = list(dependencies_packages.intersection(dev_dependencies_packages))

    if duplicated_packages:
        error_message = "check_duplicates_in_dependendies: These packages are duplicated in dependencies and " \
                        "devDependencies:\n  {} "\
                        .format("\n  ".join(duplicated_packages))

        raise CheckExecutionError(error_message)
