# -*- coding: utf-8 -*-

from psycopg2.extras import Json


def save_metrics(connection, metrics):
    cursor = connection.cursor()

    SQL = "INSERT INTO metrics (\
    app_owner, \
    app_repo, \
    project, \
    app_branch, \
    commit, \
    test_mode, \
    test_page, \
    compare_id, \
    sandbox_task_id, \
    sample_url, \
    test_url, \
    porchmark_config, \
    porchmark_version, \
    report_version, \
    format_version, \
    started_at, \
    completed_at, \
    status, \
    status_message, \
    extra, \
    request_start, \
    response_start, \
    response_end, \
    first_paint, \
    first_contentful_paint, \
    dom_content_loaded_event_end, \
    load_event_end, \
    dom_interactive, \
    dom_complete, \
    market_ttr, \
    market_tti, \
    node_count, \
    image_count, \
    script_count, \
    style_count, \
    transfer_size, \
    encoded_body_size, \
    decoded_body_size, \
    diff_request_start, \
    diff_response_start, \
    diff_response_end, \
    diff_first_paint, \
    diff_first_contentful_paint, \
    diff_dom_content_loaded_event_end, \
    diff_load_event_end, \
    diff_dom_interactive, \
    diff_dom_complete, \
    diff_market_ttr, \
    diff_market_tti, \
    diff_node_count, \
    diff_image_count, \
    diff_script_count, \
    diff_style_count, \
    diff_transfer_size, \
    diff_encoded_body_size, \
    diff_decoded_body_size\
    ) VALUES ( \
        %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, \
        %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, \
        %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, \
        %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, \
        %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, \
        %s, %s, %s, %s, %s, %s \
    )"
    data = (
        metrics["app_owner"],
        metrics["app_repo"],
        metrics["project"],
        metrics["app_branch"],
        metrics["commit"],
        metrics["test_mode"],
        metrics["test_page"],
        metrics["compare_id"],
        metrics["sandbox_task_id"],
        metrics["sample_url"],
        metrics["test_url"],
        Json(metrics["porchmark_config"]),
        metrics["porchmark_version"],
        metrics["report_version"],
        metrics["format_version"],
        metrics["started_at"],
        metrics["completed_at"],
        metrics["status"],
        metrics["status_message"],
        Json(metrics["extra"]),
        Json(metrics["request_start"]),
        Json(metrics["response_start"]),
        Json(metrics["response_end"]),
        Json(metrics["first_paint"]),
        Json(metrics["first_contentful_paint"]),
        Json(metrics["dom_content_loaded_event_end"]),
        Json(metrics["load_event_end"]),
        Json(metrics["dom_interactive"]),
        Json(metrics["dom_complete"]),
        Json(metrics["market_ttr"]),
        Json(metrics["market_tti"]),
        Json(metrics["node_count"]),
        Json(metrics["image_count"]),
        Json(metrics["script_count"]),
        Json(metrics["style_count"]),
        Json(metrics["transfer_size"]),
        Json(metrics["encoded_body_size"]),
        Json(metrics["decoded_body_size"]),
        Json(metrics["diff_request_start"]),
        Json(metrics["diff_response_start"]),
        Json(metrics["diff_response_end"]),
        Json(metrics["diff_first_paint"]),
        Json(metrics["diff_first_contentful_paint"]),
        Json(metrics["diff_dom_content_loaded_event_end"]),
        Json(metrics["diff_load_event_end"]),
        Json(metrics["diff_dom_interactive"]),
        Json(metrics["diff_dom_complete"]),
        Json(metrics["diff_market_ttr"]),
        Json(metrics["diff_market_tti"]),
        Json(metrics["diff_node_count"]),
        Json(metrics["diff_image_count"]),
        Json(metrics["diff_script_count"]),
        Json(metrics["diff_style_count"]),
        Json(metrics["diff_transfer_size"]),
        Json(metrics["diff_encoded_body_size"]),
        Json(metrics["diff_decoded_body_size"]),
    )

    cursor.execute(SQL, data)
    connection.commit()
    cursor.close()
