# coding=utf-8

import logging


from sandbox import sdk2

from sandbox.common.types import task as ctt
from sandbox.projects.market.front.helpers.sandbox_helpers import rich_check_call
from sandbox.projects.market.front.MarketFrontSimpleBashSaveHtmlReport import MarketFrontSimpleBashSaveHtmlReport
from sandbox.projects.market.resources import MARKET_SCREENSHOTS_PACK
from sandbox.projects.market.front.helpers.sandbox_helpers import rich_check_call


class MarketFrontScreenshotTestUpdate(MarketFrontSimpleBashSaveHtmlReport):
    """
    Обновление эталонов для jest-puppeteer скриншот тестов
    """

    TOOL = 'jest-puppeteer'

    class Parameters(MarketFrontSimpleBashSaveHtmlReport.Parameters):
        screen_pack_url = sdk2.parameters.String(
            'Хост стенда эталонов',
            description='При обновлении или поиске ресурса с эталонами скриншотов'
                        ' можно изменить адрес хоста, которому он соответствует'
        )

        app_src_dir = sdk2.parameters.String(
            "Кастомный путь корня приложения внутри репозитория",
            default="app_src"
        )

    def _run_build(self):
        self._clone_repo()

        try:
            rich_check_call(
                ["make", "screenshot-update"],
                self, "update_screenshot_command", cwd=self.Parameters.app_src_dir, env=self.check_env
            )

        finally:
            self._create_pack()
    
    def _create_pack(self, **kwargs):
        logging.info('Saving {} screenshot pack'.format(self.TOOL))

        abs_path = self.path(self.Parameters.app_src_dir, 'screenshots.tar.gz')

        if not abs_path.exists():
            logging.debug('Not adding resource {}: no such path'.format(abs_path))
            return

        rel_path = abs_path.relative_to(self.path())
        attributes = dict({
            'status': ctt.Status.SUCCESS,
            'ttl': 365,
            'tool': self.TOOL,
            'type': 'screenshots-pack',
            'host': self.Parameters.screen_pack_url
        },
            **kwargs
        )

        resource = MARKET_SCREENSHOTS_PACK(self, "Screenshots pack", str(rel_path), **attributes)

        sdk2.ResourceData(resource).ready()
