# coding=utf-8

import os.path
import os

from sandbox import sdk2
import sandbox.common.types.misc as ctm

from sandbox.projects.market.front.helpers.MetatronEnv import MetatronEnv
from sandbox.projects.market.front.helpers.sandbox_helpers import rich_check_call
from sandbox.projects.market.front.helpers.ubuntu import create_ubuntu_selector, setup_container
from sandbox.projects.market.front.helpers.node import create_node_selector
from sandbox.sdk2.vcs.git import Git


class MarketFrontSimpleBash(sdk2.Task):
    """
    Таска для выполнения проектных скриптов в СБ
    """

    APP_SRC_DIR = "app_src"
    GITHUB_TOKEN_VAULT_KEY = "robot-metatron-github-token"

    class Parameters(sdk2.Task.Parameters):
        github_owner = sdk2.parameters.String(
            "Github owner",
            default_value="market"
        )

        github_repo = sdk2.parameters.String(
            "Github repo"
        )

        default_branch = sdk2.parameters.String(
            "Default branch",
            default_value="master"
        )

        commit_hash = sdk2.parameters.String(
            "Хэш коммита, на который нужно ресетнуться перед выполнением скрипта"
        )

        execution_command = sdk2.parameters.String(
            "Команда для выполнения"
        )

        check_env = sdk2.parameters.Dict("Переменные окружения для запуска проверки")

        vault_env = sdk2.parameters.Dict("Добавить значения из Vault в переменные окружения, ключ - переменная окружения, значение - owner:key")

        ubuntu_version = create_ubuntu_selector()
        node_version = create_node_selector()

    class Requirements(sdk2.Task.Requirements):
        dns = ctm.DnsType.DNS64

    @property
    def check_env(self):
        env = os.environ.copy()
        if self.Parameters.check_env:
            env.update(self.Parameters.check_env)
        if self.Parameters.vault_env:
            env.update(dict(map(lambda kv: (kv[0], sdk2.Vault.data(*kv[1].split(':'))), self.Parameters.vault_env.items())))
        return env

    def on_enqueue(self):
        super(MarketFrontSimpleBash, self).on_enqueue()
        setup_container(self)

    def on_execute(self):
        super(MarketFrontSimpleBash, self).on_execute()

        with MetatronEnv(self, nodejs_version=self.Parameters.node_version):
            self._run_build()

    @property
    def _git_url(self):
        return "https://github.yandex-team.ru/{}/{}.git".format(
            self.Parameters.github_owner,
            self.Parameters.github_repo
        )

    def _run_build(self):
        git = Git(self._git_url)
        if (self.Parameters.commit_hash):
            git.clone(self.APP_SRC_DIR, commit=self.Parameters.commit_hash)
        else:
            git.clone(self.APP_SRC_DIR, self.Parameters.default_branch)

        rich_check_call(
            ["bash", "-c", self.Parameters.execution_command],
            self, "execution_command", cwd=self.APP_SRC_DIR, env=self.check_env
        )
