# coding=utf-8

import logging

from sandbox import sdk2

from sandbox.projects.market.front.resources.yammy_resources import MarketFrontYammyBuildArtefact
from sandbox.projects.market.front.MarketFrontYammyBase import MarketFrontYammyBase
from sandbox.projects.market.front.MarketFrontYammyBuildPackage import MarketFrontYammyBuildPackage


class MarketFrontYammyBuildAll(MarketFrontYammyBase):
    """
    Таск сборки пакетов
    """

    prebuilt = None

    class Parameters(MarketFrontYammyBase.Parameters):
        MarketFrontYammyBase.Parameters.description(default="Build all changed packages")

        with MarketFrontYammyBase.Parameters.yammy() as yammy:
            yammy_build_meta = MarketFrontYammyBase.Parameters.yammy_build_meta(required=True)
            yammy_prebuilt = MarketFrontYammyBase.Parameters.yammy_prebuilt(required=True)

        with sdk2.parameters.Output:
            build = sdk2.parameters.Resource(
                "Результат сборки",
                resource_type=MarketFrontYammyBuildArtefact
            )

    def on_enqueue(self):
        super(MarketFrontYammyBuildAll, self).on_enqueue()
        self.prepend_tags('build', 'build-all')

    def bootstrap(self):
        if self.Parameters.yammy_prebuilt.__attrs__['stage'] == 'build':
            self.prebuilt = self.Parameters.yammy_prebuilt
            return

        resource = self.find_build_layer(
            stage='build',
            commit=self.git_helper.commit,
            build=self.build_meta['digest']
        )

        if resource:
            self.prebuilt = resource
            return

        if not self.Context.tasks_ready:
            tasks = self._create_tasks()

            if len(tasks):
                self.wait_tasks(tasks.values())
            else:
                # FIXME: научиться менять ttl у готовых ресурсов
                self.prebuilt = self.Parameters.yammy_prebuilt
                return

        self.Context.tasks_ready = True

        super(MarketFrontYammyBuildAll, self).bootstrap()

        self._install_packages()

    def _create_tasks(self):
        with self.memoize_stage.create_tasks(max_runs=1):
            tasks = dict()

            for params in self.build_meta["build"]:
                wait_tasks = dict()
                wait_artefacts = dict()

                for dependency in params["dependsOn"]:
                    wait_tasks[dependency["task"]] = tasks[dependency["task"]]
                    wait_artefacts[dependency["task"]] = ",".join(dependency["artefacts"])

                tasks[params["name"]] = self._create_task(
                    params["name"], params["packages"], wait_tasks, wait_artefacts
                )

            self.Context.tasks = tasks

        return self.Context.tasks

    def _create_task(self, name, packages, wait_tasks, wait_artifacts):
        logging.info("Creating task {} for built packages: {}".format(name, packages))

        task = MarketFrontYammyBuildPackage(
            self,

            yammy_packages=packages,
            yammy_wait_builds=wait_tasks,
            yammy_wait_artefacts=wait_artifacts,

            **dict(
                self.Parameters,
                description="Build packages: {}".format(name),
                github_context="",
            )
        )

        with self.timer("build:{}:enqueue".format(task.id)):
            task.enqueue()

        return task.id

    def _install_packages(self):
        logging.info('Installing build artefacts')

        for (name, taks_id) in self.Context.tasks.items():
            task = sdk2.Task[taks_id]

            logging.debug('Installing {}:{} artefacts: {}'.format(name, taks_id, task.Parameters.build_results))

            for (artefact_name, artefact_id) in task.Parameters.build_results.items():
                self.install_package_artefact(artefact_name, artefact_id)

    def run_task(self):
        if self.prebuilt:
            self.Parameters.build = self.prebuilt
        else:
            self.create_build_meta()
            self.publish_prebuilt("build")
