# coding=utf-8
import logging

from sandbox.projects.market.front.MarketFrontYammyBase import MarketFrontYammyBase
from sandbox.projects.market.front.helpers.github import GitHubStatus, GitHubYammyStatusDescription


class MarketFrontYammyEvergreen(MarketFrontYammyBase):
    """
    Унифицированная таска для запуска yammy-based сценариев в монорепе
    """

    class Parameters(MarketFrontYammyBase.Parameters):
        MarketFrontYammyBase.Parameters.description(default_value="yammy evergreen cube")

        # FIXME: раскоментировать после https://st.yandex-team.ru/DEVTOOLSSUPPORT-7686
        # with MarketFrontYammyBase.Parameters.yammy() as yammy:
        #     yammy_prebuilt = None

    def on_enqueue(self):
        super(MarketFrontYammyEvergreen, self).on_enqueue()
        self.prepend_tags('evergreen')

    def update_plan(self):
        if not self.Parameters.commit_hash or not self.Parameters.github_context:
            return

        logging.info("Setting github statuses for planned tasks")

        for context in ('2.0 Test bootstrap', '2.1 Test build'):
            self.update_status(GitHubStatus.SUCCESS, GitHubYammyStatusDescription.skipped, context, url="")

        for (stage, stage_tests) in self.build_meta["test"].items():
            for (package, test_list) in stage_tests.items():
                for test_config in test_list:
                    context = self.package_task_context(package, "test:{}".format(stage), test_config)
                    self.update_status(GitHubStatus.SUCCESS, GitHubYammyStatusDescription.skipped, context, url="")

        for (stage, stage_tests) in self.build_meta["skipped"].items():
            for (package, test_list) in stage_tests.items():
                for test_config in test_list:
                    context = self.package_task_context(package, "test:{}".format(stage), test_config)
                    self.update_status(GitHubStatus.SUCCESS, GitHubYammyStatusDescription.skipped, context, url="")

    def bootstrap(self):
        pass

    def run_task(self):
        self.update_plan()
