# coding=utf-8

import json
import logging

from sandbox.projects.market.front.MarketFrontYammyBase import MarketFrontYammyBase
from sandbox.projects.sandbox_ci.utils.request import send_request


class MarketFrontYammyJailCi(MarketFrontYammyBase):
    """
    Запуск SandboxCI проверок для jailed пакетов
    """

    SANDBOX_CI_URL = "https://sandbox-ci.si.yandex-team.ru/v1/hooks/github?configPath={path}"

    SANDBOX_CI_HEADERS = {
        "Content-Type": "application/json",
        "X-GitHub-Event": "pull_request",
        "X-GitHub-Delivery": "market-yammy-fake-delivery",
        "X-GitHub-Enterprise-Host": "github.yandex-team.ru",
        "X-GitHub-Enterprise-Version": "2.21.11",
    }

    class Parameters(MarketFrontYammyBase.Parameters):
        with MarketFrontYammyBase.Parameters.yammy() as yammy:
            yammy_base_ref = MarketFrontYammyBase.Parameters.yammy_base_ref(required=True)
            yammy_build_meta = MarketFrontYammyBase.Parameters.yammy_build_meta(required=True)
            # FIXME: раскоментировать после https://st.yandex-team.ru/DEVTOOLSSUPPORT-7686
            # yammy_prebuilt = None

    @property
    def sandbox_ci_paths(self):
        return self.build_meta["sandboxCI"] if "sandboxCI" in self.build_meta else []

    @property
    def payload(self):
        repo = {
            "fork": False,
            "name": self.Parameters.github_repo,
            "owner": {"login": self.Parameters.github_owner},
            "full_name": "{}/{}".format(self.Parameters.github_owner, self.Parameters.github_repo),
            "default_branch": "master"
        }

        return {
            "action": "synchronize",
            "number": self.Parameters.pr_number,

            "pull_request": {
                "number": self.Parameters.pr_number,
                "state": "open",
                "merged": False,
                "mergeable": True,
                "rebaseable": True,
                "mergeable_state": "unstable",

                "head": {
                    "ref": self.Parameters.head_branch,
                    "sha": self.head_commit,
                    "repo": repo
                },
                "base": {
                    "ref": "master",
                    "sha": self.base_commit,
                    "repo": repo
                }
            },
            "repository": repo
        }

    def on_enqueue(self):
        super(MarketFrontYammyJailCi, self).on_enqueue()
        self.prepend_tags("yammy-jail")

    def bootstrap(self, prebuilt=None):
        if not self.Parameters.yammy_base_ref or not self.Parameters.commit_hash:
            self.git_helper.clone()

    def send_request(self, path):
        data = self.payload
        url = self.SANDBOX_CI_URL.format(path=path)

        logging.debug("SandboxCI request: {}\n{}".format(url, data))

        res = send_request(
            "post",
            url,
            headers=self.SANDBOX_CI_HEADERS,
            data=json.dumps(data)
        )

        logging.debug("SandboxCI response: {}".format(res.text))

        res.raise_for_status()

        self.set_info("<b>SandboxCI hook for '{}'</b>:\n{}".format(path, res.text), do_escape=False)

    def run_task(self):
        for path in self.sandbox_ci_paths:
            self.send_request(path)
