# coding=utf-8

import os
import logging

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp

from sandbox.projects.sandbox.sandbox_lxc_image import RichTextTaskFailure
from sandbox.projects.market.front.MarketFrontYammyBase import MarketFrontYammyBase
from sandbox.projects.market.front.helpers.sandbox_helpers import get_resource_http_proxy_link


class MarketFrontYammyPackageTask(MarketFrontYammyBase):
    """
    Таск запуска скриптов для отдельного пакета
    """

    alias = "task"

    class Parameters(MarketFrontYammyBase.Parameters):
        with MarketFrontYammyBase.Parameters.yammy() as yammy:
            yammy_build_meta = MarketFrontYammyBase.Parameters.yammy_build_meta(required=True)
            yammy_prebuilt = MarketFrontYammyBase.Parameters.yammy_prebuilt(required=True)

            yammy_package = sdk2.parameters.String("Название пакета", required=True)
            yammy_command = sdk2.parameters.String("Команда", required=True)
            yammy_command_name = sdk2.parameters.String("Название команды", required=True)
            yammy_command_title = sdk2.parameters.String("Название команды (человекочитаемое)", required=True)

        with sdk2.parameters.Output:
            result = sdk2.parameters.String("Опубликованная версия")

    @property
    def output_dir(self):
        output = self.publish_path('output')
        if not os.path.exists(output):
            os.mkdir(output)
        return output

    def output_file(self, *chunks):
        return os.path.join(self.output_dir, *chunks)

    def setup_env(self):
        super(MarketFrontYammyPackageTask, self).setup_env()
        os.environ["YAMMY_PACKAGE"] = str(self.Parameters.yammy_package)
        os.environ["YAMMY_COMMAND_NAME"] = str(self.Parameters.yammy_command_name)
        os.environ["YAMMY_COMMAND_TITLE"] = str(self.Parameters.yammy_command_title)

    def on_enqueue(self):
        super(MarketFrontYammyPackageTask, self).on_enqueue()
        self.prepend_tags(
            self.alias,
            self.Parameters.yammy_package.replace('@', '').replace('/', '_'),
        )

    def run_command(self, error_class=RichTextTaskFailure):
        logging.info("Running package '{}' {} '{}'".format(
            self.Parameters.yammy_package,
            self.alias,
            self.Parameters.yammy_command_title
        ))

        logfile = "{}.out.log".format("command_run")

        with self.timer("command"), sdk2.helpers.ProcessLog(self, "command_run") as log:
            proc = sp.Popen(
                ["bash", "-c", self.Parameters.yammy_command],
                stdout=sp.PIPE, stderr=log.stdout, env=os.environ, cwd=self.APP_SRC_DIR
            )

            returncode = proc.wait()

            stdout = proc.stdout.read()
            error = None

            if returncode != 0:
                error = error_class(
                    self,
                    "Command {!r} failed, see the log below. <b><a href='{}'>{}</a></b>".format(
                        "command_run",
                        "/".join((get_resource_http_proxy_link(self.log_resource), logfile)),
                        logfile
                    ),
                )

            return (stdout, error)

    def run_task(self):
        (stdout, error) = self.run_command()

        if error:
            raise error
