# coding=utf-8

from sandbox import sdk2
from sandbox.projects.market.front.MarketFrontYammyPackageTask import MarketFrontYammyPackageTask
from sandbox.projects.market.front.helpers.github import GitHubStatus


class MarketFrontYammyPublishNpm(MarketFrontYammyPackageTask):
    """
    Таск публикации пакета в npm
    """

    alias = "publish"

    class Parameters(MarketFrontYammyPackageTask.Parameters):
        with sdk2.parameters.Output:
            result = sdk2.parameters.String("Опубликованная версия")

    def update_status(self, state, description, context=None, url=None):
        if state in (GitHubStatus.ERROR, GitHubStatus.FAILURE):
            super(MarketFrontYammyPublishNpm, self).update_status(state, description, context=None, url=None)

    def on_enqueue(self):
        self.prepend_tags('publish-npm')
        super(MarketFrontYammyPublishNpm, self).on_enqueue()

    def run_task(self):
        (stdout, error) = self.run_command()

        if error:
            raise error

        with self.timer("result"):
            self.Parameters.result = stdout
