# coding=utf-8

import os
import json

from sandbox import sdk2
from sandbox.common.types import task as ctt

from sandbox.projects.market.front.MarketFrontYammyTestDeploy import MarketFrontYammyTestDeploy
from sandbox.projects.sandbox_ci.managers import ConfigManager


class MarketFrontYammyTestHermione(MarketFrontYammyTestDeploy):
    """
    Таск сборки пакетов
    """

    _genisys_manager = None
    _genisys_config = None

    class Parameters(MarketFrontYammyTestDeploy.Parameters):
        with MarketFrontYammyTestDeploy.Parameters.test_params():
            test_genisys_context = sdk2.parameters.String(
                'Профиль конфигурации в Genisys',
                description='https://wiki.yandex-team.ru/Market/Verstka/SandboxCookBook/#profilikonfiguracijjzapuska',
            )

            test_genisys_override = sdk2.parameters.String("Внешний конфиг Genisys")
            test_browsers = sdk2.parameters.JSON('Hermione browsers')

    @property
    def genisys_manager(self):
        if not self._genisys_manager:
            with self.timer("genisys:init"):
                self._genisys_manager = ConfigManager(self)

        return self._genisys_manager

    @property
    def genisys_config(self):
        if not self._genisys_config:
            with self.timer("genisys:whole"):
                whole_config = self.genisys_manager.get_properties('sandbox-ci-market')

            with self.timer("genisys:project"):
                self._genisys_config = self.genisys_manager.get_project_conf(whole_config, {
                    'project_name': self.git_helper.full_repo_name,
                    'build_context': self.Parameters.test_genisys_context or None,
                    'external_config': self.Parameters.test_genisys_override or None,
                })

        return self._genisys_config

    @property
    def browsers(self):
        return self.Parameters.test_browsers or self.genisys_config.get('hermione_browsers', {})

    def on_enqueue(self):
        super(MarketFrontYammyTestHermione, self).on_enqueue()

        browsers = self.browsers
        browsers_total = 0

        for browser in browsers.values():
            browsers_total += browser.get('sessionsPerBrowser', 1)

        self.Requirements.semaphores = ctt.Semaphores(
            acquires=[
                ctt.Semaphores.Acquire(
                    name="market-autotests-browser",
                    capacity=1000,
                    weight=browsers_total or 1
                ),
                ctt.Semaphores.Acquire(
                    name="market-autotests-package-{}".format(self.Parameters.yammy_package),
                    capacity=1000,
                    weight=1,
                )
            ],
            release=(
                ctt.Status.Group.BREAK,
                ctt.Status.Group.FINISH,
            )
        )

    def setup_env(self):
        super(MarketFrontYammyTestHermione, self).setup_env()

        os.environ.update(self.genisys_config.get('environ', {}))
        os.environ["TEST_BROWSERS"] = json.dumps(self.browsers)
