import re


def propagate_github_event_data(task):
    event = task.Context.githubEvent

    if not event:
        return

    assert event["type"] == "pull_request"

    payload = event["payload"]
    repo = payload["repository"]
    pr = payload["pull_request"]

    if hasattr(task.Parameters, "head_branch"):
        task.Parameters.head_branch = pr["head"]["ref"]

    if hasattr(task.Parameters, "pr_title"):
        task.Parameters.pr_title = pr["title"]

    if hasattr(task.Parameters, "pr_number"):
        task.Parameters.pr_number = payload["number"]

    if hasattr(task.Parameters, "commit_hash"):
        task.Parameters.commit_hash = pr["head"]["sha"]

    if hasattr(task.Parameters, "github_owner"):
        task.Parameters.github_owner = repo["owner"]["login"]

    if hasattr(task.Parameters, "github_repo"):
        task.Parameters.github_repo = repo["name"]

    if hasattr(task, "pr_is_mergeable"):
        task.pr_is_mergeable = pr["mergeable"]


_TICKET_NUMBER_RE = re.compile(r"^[A-Z]+-\d+\b")


def extract_ticket_id(pr_title):
    match = _TICKET_NUMBER_RE.match(pr_title)

    if not match:
        return None

    return match.group()


def is_release(pr_title):
    return "Release 20" in pr_title
