# -*- coding: utf-8 -*-

import logging

import requests

from sandbox.projects.sandbox_ci.utils.request import send_request

STAFF_API_URL = "https://staff-api.yandex-team.ru/v3"


def get_telegram_login_by_staff_login(token, staff_login):
    """
    По логину на стаффе возвращает первый из привязанных telegram аккаунтов человека.
    Логин возвращается без собачки и в нижнем регистре, т.е. lengl вместо @Lengl
    Возвращает None если найти аккаунт не удалось.
    :param token: OAuth токен с доступом к стаффу (подойдёт токен Startrek)
    :param staff_login: Логин человека чей телеграм надо найти
    :return:
    """
    if token is None or len(token) == 0:
        raise Exception("Не указан oauth_token для обращения к Staff api")

    headers = {
        'Authorization': 'OAuth {}'.format(token),
        'Content-Type': 'application/json'
    }
    params = {
        "_one": 1,
        "login": staff_login,
        "_fields": "accounts"
    }
    url = "{}/persons?{}".format(STAFF_API_URL, params_to_str(params))
    response = send_request(
        method="get",
        url=url,
        headers=headers,
    )  # type: requests.models.Response

    if response.status_code != 200:
        logging.error("Не удалось получить данные от staff api. Ответ staff: {} {}".format(response.status_code, response.text))
        return None

    try:
        person = response.json()
        tg_accounts = [account for account in person["accounts"] if account["type"] == "telegram"]
        return tg_accounts[0]["value_lower"]
    except (ValueError, KeyError) as e:
        logging.error(e)
    except IndexError:
        # Ничего не делаем, нет привязанного телеграмма у человека
        pass

    return None


def params_to_str(
    params
):
    param_list = ["{}={}".format(key, value) for key, value in params.items()]
    return "&".join(param_list)
