# coding=utf-8

from sandbox.projects.market.resources import MarketFrontCommonNodeAppResource, MarketFrontCommonResource
from sandbox import sdk2


class MARKET_CORPSITE_WEB_FRONT(MarketFrontCommonNodeAppResource):
    """Market CorpSite Web NodeJS App"""


class MARKET_CORPSITE_FRONT_CONFIG(MarketFrontCommonResource):
    """Market CorpSite Frontend NodeJS config"""


class CmsPublicationContext(sdk2.Resource):
    pass


class CmsScreenshooterBin(sdk2.Resource):
    releasable = True
    ttl = 7


class MarketCIReport(sdk2.Resource):
    ttl = 14


class MarketFrontBuildUnifiedStaticResource(sdk2.Resource):
    releasable = False

    fix_version = sdk2.Attributes.String("Fix version", required=True)
    version = sdk2.Attributes.String("Static version", required=True)


class MarketFrontHroomDockerResource(sdk2.Resource):
    """
    Hroom resource for docker images for ydeploy
    https://a.yandex-team.ru/arc/trunk/arcadia/market/tools/hroom
    """

    releasable = True
    releasers = ["robot-metatron", "xavescor"]
