# coding=utf-8

from sandbox import sdk2

PREBUILT_TTLS = dict(
    bootstrap=7,
    prebuilt=1,
    build=14,
)


class MarketFrontYammyDebugInfo(sdk2.Resource):
    """Артефакт с отладочной информацией о сборке"""

    ttl = 1


class MarketFrontYammyMetaArtefact(sdk2.Resource):
    """Мета-информация для сборки"""

    base_commit = sdk2.Attributes.String("Коммит для отбивок")
    head_commit = sdk2.Attributes.String("Головной коммит")
    branch = sdk2.Attributes.String("Ветка")
    head_ref = sdk2.Attributes.String("Референс головного коммита")
    pr_number = sdk2.Attributes.String("Номер пулл-реквеста")
    repo = sdk2.Attributes.String("Репозиторий")
    repo_full_name = sdk2.Attributes.String("Полное имя репозитория")
    changed_packages = sdk2.Attributes.String("Изменённые пакеты")
    ttl = 7


class MarketFrontYammyBuildArtefact(sdk2.Resource):
    """Артефакт сборки репозитория"""

    commit = sdk2.Attributes.String("Коммит")
    ref = sdk2.Attributes.String("Ветка/PR/коммит")
    stage = sdk2.Attributes.String("Стадия")
    build = sdk2.Attributes.String("Айди билда")
    hash = sdk2.Attributes.String("Хеш зависимостей")
    ttl = 7


class MarketFrontYammyTestArtefact(sdk2.Resource):
    """Артефакт отчёта о тестировании"""

    commit = sdk2.Attributes.String("Коммит")
    ref = sdk2.Attributes.String("Ветка/PR/коммит")
    test_stage = sdk2.Attributes.String("Стадия")
    test_name = sdk2.Attributes.String("Название теста")
    report_file = sdk2.Attributes.String("Файл отчёта")
    ttl = 7


class MarketFrontYammyTestsFailedArtefact(sdk2.Resource):
    """Артефакт отчёта об упавших тестах"""

    commit = sdk2.Attributes.String("Коммит")
    ref = sdk2.Attributes.String("Ветка/PR/коммит")
    test_stage = sdk2.Attributes.String("Стадия")
    run_id = sdk2.Attributes.String("Идентификатор запуска")
    ttl = 1


class MarketFrontYammyBuildPackageArtefact(sdk2.Resource):
    """Артефакт сборки единичного пакета"""

    package = sdk2.Attributes.String("Пакет")
    commit = sdk2.Attributes.String("Топовый коммит с изменениями")
    build = sdk2.Attributes.String("Название билда")
    ttl = 14


class MarketFrontYammyPublishSummary(sdk2.Resource):
    """Артефакт мета-информации об опубликованных пакетах"""

    commit = sdk2.Attributes.String("Коммит с изменениями")
    ttl = 7
