# -*- coding: utf-8 -*-
import os
import json
from sandbox import sdk2
from sandbox.sdk2 import service_resources
from sandbox.projects.market.resources import MARKET_AUTOTEST_STATS, MARKET_AUTOTEST_ERRORS
import sandbox.common.types.resource as ctr
from sandbox.projects.market.frontarc.MarketAutotestsHermioneSendMetricsArc.metrics import create_metrics_params
from sandbox.projects.market.frontarc.MarketAutotestsHermioneSendMetricsArc.write_to_lb import write_to_logbroker, MESSAGE_FORMAT_JSON


class MarketAutotestsHermioneSendMetricsArc(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        stats_resource = sdk2.parameters.Resource(
            'Ресурс со статами',
            resource_type=MARKET_AUTOTEST_STATS,
            required=True
        )
        errors_resource = sdk2.parameters.Resource(
            'Ресурс с ошибками о прохождении тестов',
            resource_type=MARKET_AUTOTEST_ERRORS,
            required=True
        )
        metrics_params = create_metrics_params()

    def on_create(self):
        self.Requirements.tasks_resource = service_resources.SandboxTasksBinary.find(
            attrs={"task_type": "MARKET_AUTOTESTS_HERMIONE_SEND_METRICS_ARC", "released": "stable"},
            state=ctr.State.READY
        ).first()

    def on_execute(self):
        self._send_metrics()
        self._send_errors()

    def _send_metrics(self):
        if self.Parameters.stats_resource is None:
            return

        resource = MARKET_AUTOTEST_STATS[self.Parameters.stats_resource]
        resource_data = sdk2.ResourceData(resource)
        metrics_file_path = str(resource_data.path)
        if os.path.isdir(metrics_file_path):
            metrics_file_path = os.path.join(metrics_file_path, os.listdir(metrics_file_path)[0])
        with open(metrics_file_path) as f1:
            cases_stats = json.load(f1)
        write_to_logbroker(
            self.Parameters.logbroker_topic,
            self.Parameters.logbroker_endpoint,
            self.Parameters.logbroker_port,
            "MarketAutotestsHermioneSendMetrics",
            bytes(self.Parameters.logbroker_oauth.data()),
            cases_stats,
            "market_front_sandbox-autotest-stats.log",
            MESSAGE_FORMAT_JSON
        )

    def _send_errors(self):
        if self.Parameters.errors_resource is None:
            return

        resource = MARKET_AUTOTEST_ERRORS[self.Parameters.errors_resource]
        resource_data = sdk2.ResourceData(resource)
        errors_file_path = str(resource_data.path)
        if os.path.isdir(errors_file_path):
            errors_file_path = os.path.join(errors_file_path, os.listdir(errors_file_path)[0])
        with open(errors_file_path) as f1:
            cases_errors = json.load(f1)
        write_to_logbroker(
            self.Parameters.logbroker_errors_topic,
            self.Parameters.logbroker_endpoint,
            self.Parameters.logbroker_port,
            "MarketAutotestsHermioneSendMetrics",
            bytes(self.Parameters.logbroker_oauth.data()),
            cases_errors,
            "market_front_sandbox-autotest-errors.log",
            MESSAGE_FORMAT_JSON
        )
