# coding=utf-8

from sandbox.projects.market.frontarc.helpers.sandbox_helpers import rich_check_call
from sandbox.projects.market.frontarc.MarketFrontBuildPlatformNodeArc import MarketFrontBuildPlatformNodeArc
from sandbox.projects.market.resources import MARKET_BLACK_DESKTOP_FRONT

from sandbox import sdk2


class MarketFrontBuildBlackDesktopNodeArc(MarketFrontBuildPlatformNodeArc):
    """
    Task to build market black desktop node application
    """

    @property
    def app_repo(self):
        return "market/front/apps/marketfront"

    @property
    def static_root(self):
        return "market-blackdesktop/_"

    @property
    def resource_type(self):
        return MARKET_BLACK_DESKTOP_FRONT

    @property
    def static_package_name(self):
        return "yandex-market-blackdesktop-static"

    @property
    def make_env(self):
        env = super(MarketFrontBuildPlatformNodeArc, self).make_env
        if self.is_platform_build:
            env.update({"PROJECT": self.app_src_dir, "APP_PLATFORM": self.platform, "REAL_CORE": "1"})
        return env

    class Parameters(MarketFrontBuildPlatformNodeArc.Parameters):
        with MarketFrontBuildPlatformNodeArc.Parameters.app() as app:
            app_platform = sdk2.parameters.String("Платформа приложения", required=True, default_value="desktop")

    def prebuild(self, app_src_path):
        rich_check_call(
            ["ln", "-snf", "./market", "./business"],
            task=self, alias="Create business symlink", cwd=app_src_path, env=self.make_env
        )
