# coding=utf-8

from sandbox.projects.market.frontarc.MarketFrontBuildPlatformNodeArc import MarketFrontBuildPlatformNodeArc
from sandbox.projects.market.frontarc.helpers.sandbox_helpers import NotPlatformBuildErrorArc
from sandbox.projects.market.resources import MARKET_BLUEDESKTOP_FRONT
from sandbox import sdk2


class MarketFrontBuildBlueDesktopNodeArc(MarketFrontBuildPlatformNodeArc):
    """
    Task to build market blue desktop node application
    """

    # todo: remove this
    #  @see: https://st.yandex-team.ru/MARKETFRONTECH-506
    #  This build is always "platform"-build
    @property
    def _app_repo(self):
        raise NotPlatformBuildErrorArc('Only platform build allowed for this task; check if "platform" param is specified')

    @property
    def static_root(self):
        return "market-bluedesktop/_"

    @property
    def resource_type(self):
        return MARKET_BLUEDESKTOP_FRONT

    @property
    def static_package_name(self):
        return "yandex-market-bluedesktop-static"

    class Parameters(MarketFrontBuildPlatformNodeArc.Parameters):
        with MarketFrontBuildPlatformNodeArc.Parameters.app() as app:
            app_platform = sdk2.parameters.String("Платформа приложения", required=True, default_value="desktop")
