# coding=utf-8

from sandbox.projects.market.frontarc.MarketFrontBuildPlatformNodeArc import MarketFrontBuildPlatformNodeArc
from sandbox.projects.market.front.resources import MARKET_CORPSITE_WEB_FRONT
from sandbox import sdk2


class MarketFrontBuildCorpSiteWebArc(MarketFrontBuildPlatformNodeArc):
    """
    Task to build market corpSite application
    """

    @property
    def app_repo(self):
        return "market/front/apps/marketcorp"

    @property
    def resource_type(self):
        return MARKET_CORPSITE_WEB_FRONT

    # Проперти пустые, т.к. сервис работает только через yastat + s3
    @property
    def static_package_name(self):
        return

    @property
    def static_root(self):
        return "market-corpsite"

    @property
    def make_env(self):
        env = super(MarketFrontBuildPlatformNodeArc, self).make_env
        if self.is_platform_build:
            env.update({"APP_PLATFORM": self.platform})
        return env

    class Parameters(MarketFrontBuildPlatformNodeArc.Parameters):
        with MarketFrontBuildPlatformNodeArc.Parameters.app() as app:
            app_platform = sdk2.parameters.String("Платформа приложения", required=True, default_value="desktop")
