# coding=utf-8

import sandbox.projects.market.frontarc.helpers.s3 as s3
from sandbox.projects.market.frontarc.MarketFrontNodejsBuildAbstractArc import MarketFrontNodejsBuildAbstractArc, GenericParametersArc

from sandbox import sdk2

PLATFORM_DESKTOP = "desktop"
PLATFORM_TOUCH = "touch"
PLATFORMS = [PLATFORM_DESKTOP, PLATFORM_TOUCH]


class MarketFrontBuildPlatformNodeArc(MarketFrontNodejsBuildAbstractArc):
    """
    Task to build market blue node applications
    """

    _unified_repo = "market/front/apps/marketfront"

    @property
    def _app_repo(self):
        raise NotImplementedError

    @property
    def _app_src_dir(self):
        raise NotImplementedError

    @property
    def is_platform_build(self):
        return self.Parameters.is_platform_build

    @property
    def platform(self):
        return None if not self.is_platform_build else self.Parameters.app_platform

    @property
    def app_repo(self):
        if self.is_platform_build:
            return self.Parameters.app_repo or self._unified_repo

        return self._app_repo

    @property
    def app_src_dir(self):
        if self.is_platform_build:
            return self.Parameters.app_src_dir

        return self._app_src_dir

    @property
    def s3_prefix(self):
        return s3.s3_path_by_repo(self.app_repo, self.platform, self.app_src_dir)

    @property
    def make_env(self):
        env = super(MarketFrontBuildPlatformNodeArc, self).make_env
        if self.is_platform_build:
            env.update({"BLUE_PLATFORM": self.platform, "REAL_CORE": "1"})

        return env

    @property
    def dist_dir(self):
        dist_dir = super(MarketFrontBuildPlatformNodeArc, self).dist_dir

        if not dist_dir and self.is_platform_build:
            # удалить platform в MARKETFRONTECH-506
            dist_dir = self.platform

        return dist_dir

    class Parameters(GenericParametersArc):
        with GenericParametersArc.app() as app:
            is_platform_build = sdk2.parameters.Bool(
                "Платформенная сборка",
                default=False,
                required=True
            )

            with is_platform_build.value[True]:
                with sdk2.parameters.String("Платформа приложения", required=True, multiline=True) as app_platform:
                    for platform in PLATFORMS:
                        app_platform.values[platform] = app_platform.Value(platform)

                with GenericParametersArc.misc() as misc:
                    prune_old_style = sdk2.parameters.Bool("Old style npm prune", default=False, required=True)
