# coding=utf-8

from sandbox.projects.market.frontarc.MarketFrontBuildPlatformNodeArc import MarketFrontBuildPlatformNodeArc
from sandbox.projects.market.frontarc.helpers.startrack import FixVersion
from sandbox.projects.market.resources import MARKET_TOUCH_FRONT_API
from sandbox import sdk2


class MarketFrontBuildWhiteApiNodeArc(MarketFrontBuildPlatformNodeArc):
    """
    Task to build market white api node application
    """

    @property
    def app_repo(self):
        return "market/front/apps/marketfront"

    @property
    def resource_type(self):
        return MARKET_TOUCH_FRONT_API

    @property
    def make_env(self):
        env = super(MarketFrontBuildPlatformNodeArc, self).make_env
        if self.is_platform_build:
            env.update({"APP_PLATFORM": self.platform, "REAL_CORE": "1"})
        return env

    class Parameters(MarketFrontBuildPlatformNodeArc.Parameters):
        copy_static = sdk2.parameters.Bool("Копировать фриз статики в приложение", required=True, default=False)
        upload_static_to_s3 = sdk2.parameters.Bool("Загружать статику в s3", required=True, default=False)
        build_static = sdk2.parameters.Bool("Проводить сборку статического пакета", required=True, default=False)

        with build_static.value[True]:
            fix_version = FixVersion("Фикс-версия релиза в формате YYYY.R.PS", required=True)

        with MarketFrontBuildPlatformNodeArc.Parameters.app() as app:
            app_platform = sdk2.parameters.String("Платформа приложения", required=True, default_value="api")
