# coding=utf-8

from sandbox.projects.market.frontarc.MarketFrontBuildPlatformNodeArc import MarketFrontBuildPlatformNodeArc
from sandbox.projects.market.resources import MARKET_TOUCH_FRONT

from sandbox import sdk2


class MarketFrontBuildWhiteTouchNodeArc(MarketFrontBuildPlatformNodeArc):
    """
    Task to build market white touch node application
    """

    @property
    def app_repo(self):
        return "market/front/apps/marketfront"

    @property
    def static_root(self):
        return "market-touch/_"

    @property
    def resource_type(self):
        return MARKET_TOUCH_FRONT

    @property
    def static_package_name(self):
        return "yandex-market-touch-static"

    @property
    def make_env(self):
        env = super(MarketFrontBuildPlatformNodeArc, self).make_env
        if self.is_platform_build:
            env.update({"APP_PLATFORM": self.platform, "REAL_CORE": "1"})
        return env

    class Parameters(MarketFrontBuildPlatformNodeArc.Parameters):
        with MarketFrontBuildPlatformNodeArc.Parameters.app() as app:
            app_platform = sdk2.parameters.String("Платформа приложения", required=True, default_value="touch")
