# coding=utf-8

import re

from .helpers import ValidationError, CheckExecutionError, get_packages

suitable_expressions = [
    re.compile("git"),
    re.compile("npm"),
    re.compile("^\d+\.\d+\.\d+")
]


def is_exact_version(version):
    return any(re.search(exp, version) is not None for exp in suitable_expressions)


def check_exact_versions(package_json, should_check_dev_deps=False):
    """
         Запрещает ссылаться не на конкретную версию пакета (напр. ^1.0.0)
            Аргументы
                whitelist - массив с названиями пакетов, которые будут игнорироваться
                    default: []
                should_check_dev_deps - провести проверку в devDependencies
                    default: false
    """
    if not isinstance(should_check_dev_deps, bool):
        raise ValidationError("check_exact_versions: not valid schema (should_check_dev_deps should be boolean)")

    packages = get_packages(package_json, should_check_dev_deps)

    deps_without_exact_versions = []
    for name, version in packages:
        if not is_exact_version(version):
            deps_without_exact_versions.append(name)

    if deps_without_exact_versions:
        error_message = "check_exact_versions: These packages do not have exact versions:\n  {}"\
                        .format("\n  ".join(deps_without_exact_versions))

        raise CheckExecutionError(error_message)
