# coding=utf-8

from .helpers import ValidationError, CheckExecutionError, get_packages


def check_yandex_team_github_ref(package_json, should_check_dev_deps=False, whitelist=None):
    """
        Запрещает брать пакеты с нашего гитхаба
            Аргументы
                whitelist - массив с названиями пакетов, которые будут игнорироваться
                    default: []
                should_check_dev_deps - провести проверку в devDependencies
                    default: false
    """
    if whitelist is None:
        whitelist = []

    if not isinstance(should_check_dev_deps, bool):
        raise ValidationError("check_yandex_team_github_ref: not valid schema (should_check_dev_deps should be boolean)")

    if not isinstance(whitelist, list):
        if any(not isinstance(package, str) for package in whitelist):
            raise ValidationError(("check_yandex_team_github_ref: not valid schema (whitelist should be string[])"))

    packages = get_packages(package_json, should_check_dev_deps)

    packages_with_yandex_team_github_ref = []
    for name, version in packages:
        if 'github.yandex-team' in version and name not in whitelist:
            packages_with_yandex_team_github_ref.append(name)

    if packages_with_yandex_team_github_ref:
        error_message = "check_yandex_team_github_ref: These packages have ref to github.yandex-team:\n  {} "\
                        .format("\n  ".join(packages_with_yandex_team_github_ref))

        raise CheckExecutionError(error_message)

