# coding=utf-8

import os
import tempfile
from sandbox import sdk2
import sandbox.common.types.misc as ctm

from sandbox.projects.market.frontarc.helpers.MetatronEnvArc import MetatronEnvArc
from sandbox.projects.market.frontarc.helpers.sandbox_helpers import rich_check_call
from sandbox.projects.market.frontarc.helpers.node import NODE_DEFAULT
from sandbox.projects.market.frontarc.helpers.github import clone_repo
from .container import MarketImperioContainerArc


class MarketFrontImperioArc(sdk2.Task):
    """
    Таска для imperio.
    """

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 1200

        container = MarketImperioContainerArc()

        scenarios = sdk2.parameters.String("Количество сценариев", default_value=100)
        workers = sdk2.parameters.String("Количество воркеров (выпоняют сценарии параллельно)", default_value="50%")
        spw = sdk2.parameters.String("Количество дублей сценариев на воркер (scenarios=workers*spw)", default_value=1)
        ref_name = sdk2.parameters.String("Ветка репозитория smelukov/imperio", default_value="master")

    class Requirements(sdk2.Task.Requirements):
        dns = ctm.DnsType.DNS64
        cores = 80

    def on_execute(self):
        with MetatronEnvArc(task=self, nodejs_version=NODE_DEFAULT):
            temp_dir = tempfile.mkdtemp()
            clone_repo(
                owner="smelukov",
                name="imperio",
                ref=self.Parameters.ref_name,
                target_dir=temp_dir
            )

            rich_check_call(
                command=["npm", "ci"],
                task=self,
                alias="npmci",
                cwd=temp_dir
            )

            # У ЦУМа левый сертификат
            os.environ["NODE_TLS_REJECT_UNAUTHORIZED"] = "0"
            rich_check_call(
                command=["npm", "start", "--",
                         "--workers", self.Parameters.workers,
                         "--scenarios", self.Parameters.scenarios,
                         "--scenarios-per-worker", self.Parameters.spw
                         ],
                task=self,
                alias="run_imperio",
                cwd=temp_dir
            )
