CREATE TABLE metrics (
  id UUID PRIMARY KEY NOT NULL DEFAULT uuid_generate_v1(),
  app_owner varchar(100) NOT NULL,
  app_repo varchar(100) NOT NULL,
  project varchar(50) NOT NULL,
  app_branch varchar(255) NOT NULL,
  commit varchar(60) NOT NULL,
  test_mode varchar(30) NOT NULL,
  test_page varchar(30) NOT NULL,
  compare_id varchar(300) NOT NULL,
  sandbox_task_id bigint NOT NULL,
  sample_url varchar(300) NOT NULL,
  test_url varchar(300) NOT NULL,
  porchmark_config jsonb NOT NULL,
  porchmark_version varchar(30) NOT NULL,
  report_version numeric(1) NOT NULL,
  format_version numeric(1) NOT NULL,
  created_at timestamp NOT NULL DEFAULT now(),
  updated_at timestamp NULL,
  started_at timestamp NOT NULL,
  completed_at timestamp NOT NULL,
  status varchar(20) NOT NULL,
  status_message varchar(200) NOT NULL,
  extra jsonb NULL,
  request_start jsonb NOT NULL,
  response_start jsonb NOT NULL,
  response_end jsonb NOT NULL,
  first_paint jsonb NOT NULL,
  first_contentful_paint jsonb NOT NULL,
  dom_content_loaded_event_end jsonb NOT NULL,
  load_event_end jsonb NOT NULL,
  dom_interactive jsonb NOT NULL,
  dom_complete jsonb NOT NULL,
  market_ttr jsonb NOT NULL,
  market_tti jsonb NOT NULL,
  node_count jsonb NOT NULL,
  image_count jsonb NOT NULL,
  script_count jsonb NOT NULL,
  style_count jsonb NOT NULL,
  transfer_size jsonb NOT NULL,
  encoded_body_size jsonb NOT NULL,
  decoded_body_size jsonb NOT NULL,
  diff_request_start jsonb NOT NULL,
  diff_response_start jsonb NOT NULL,
  diff_response_end jsonb NOT NULL,
  diff_first_paint jsonb NOT NULL,
  diff_first_contentful_paint jsonb NOT NULL,
  diff_dom_content_loaded_event_end jsonb NOT NULL,
  diff_load_event_end jsonb NOT NULL,
  diff_dom_interactive jsonb NOT NULL,
  diff_dom_complete jsonb NOT NULL,
  diff_market_ttr jsonb NOT NULL,
  diff_market_tti jsonb NOT NULL,
  diff_node_count jsonb NOT NULL,
  diff_image_count jsonb NOT NULL,
  diff_script_count jsonb NOT NULL,
  diff_style_count jsonb NOT NULL,
  diff_transfer_size jsonb NOT NULL,
  diff_encoded_body_size jsonb NOT NULL,
  diff_decoded_body_size jsonb NOT NULL
);

CREATE FUNCTION set_updated_at_value() RETURNS trigger
   LANGUAGE plpgsql AS
$$BEGIN
   NEW.updated_at := current_timestamp;
   RETURN NEW;
END;$$;

CREATE TRIGGER updated_at_trigger
   BEFORE UPDATE ON metrics
   FOR EACH ROW
   EXECUTE PROCEDURE set_updated_at_value();
