# coding=utf-8

import logging
import os

from sandbox import sdk2

from sandbox.common.types import task as ctt
from sandbox.projects.market.frontarc.MarketFrontSimpleBashSaveHtmlReportArc \
    import MarketFrontSimpleBashSaveHtmlReportArc
from sandbox.projects.market.resources import MARKET_SCREENSHOTS_PACK
from sandbox.projects.market.frontarc.helpers.sandbox_helpers import rich_check_call


class MarketFrontScreenshotTestUpdateArc(MarketFrontSimpleBashSaveHtmlReportArc):
    """
    Обновление эталонов для jest-puppeteer скриншот тестов
    """

    TOOL = 'jest-puppeteer'

    def _run_build(self):
        try:
            rich_check_call(
                ["make", "screenshot-update"],
                self, "update_screenshot_command", cwd=self.APP_SRC_PATH, env=self.check_env
            )

        finally:
            self._create_pack()

    def _create_pack(self, **kwargs):
        logging.info('Saving {} screenshot pack'.format(self.TOOL))

        abs_path = os.path.join(self.APP_SRC_PATH, 'screenshots.tar.gz')
        target_path = os.path.join(self.root_dir, 'screenshots.tar.gz')

        if not os.path.exists(abs_path):
            logging.debug('Not adding resource {}: no such path'.format(abs_path))
            return

        attributes = dict({
            'status': ctt.Status.SUCCESS,
            'ttl': 365,
            'tool': self.TOOL,
            'type': 'screenshots-pack',
            'host': self.Parameters.screen_pack_url
        },
            **kwargs
        )

        sdk2.helpers.subprocess.check_call(['mv', abs_path, self.root_dir])

        resource = MARKET_SCREENSHOTS_PACK(self, "Screenshots pack", target_path, **attributes)

        sdk2.ResourceData(resource).ready()
