# coding=utf-8

import re

import sandbox.common.types.misc as ctm
from sandbox import sdk2
from sandbox.projects.common import task_env
from sandbox.projects.market.frontarc.helpers.MetatronEnvArc import ST_OAUTH_TOKEN_VAULT_KEY
from sandbox.sandboxsdk.environments import PipEnvironment


class MarketFrontSetStartrekField(sdk2.Task):
    """
    Устанавливает тикету указанные в параметрах значения в указанные поля
    """

    class Requirements(task_env.TinyRequirements):
        dns = ctm.DnsType.DNS64
        disk_space = 700  # 700 Mb, потому что пакеты и всякая ерунда
        ram = 64  # 64 Mb
        environments = [
            PipEnvironment("yandex_tracker_client", version="1.3", custom_parameters=["--upgrade-strategy only-if-needed"]),
            PipEnvironment("startrek_client", version="2.3.0", custom_parameters=["--upgrade-strategy only-if-needed"])
        ]

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 4 * 60  # 4 minutes

        ticket_id = sdk2.parameters.String(
            "Номер тикета",
            description="в формате QUEUE-12345"
        )

        expected_values = sdk2.parameters.Dict(
            "Список полей ST и значений для них",
            value_type=sdk2.parameters.String
        )

    def on_execute(self):
        super(MarketFrontSetStartrekField, self).on_execute()

        assert re.match("^[A-Z]+-\\d+$", str(self.Parameters.ticket_id)) is not None, "Тикет нужен в формате `QUEUE-ID`"


        from startrek_client import Startrek
        oauth_token = sdk2.Vault.data(ST_OAUTH_TOKEN_VAULT_KEY)
        st = Startrek(useragent="robot-metatron", token=oauth_token)
        issue = st.issues[str(self.Parameters.ticket_id)]

        update = dict((key, value) for key, value in self.Parameters.expected_values.items())

        issue.update(**update)
