import logging
from sandbox import sdk2
import sandbox.common.errors as ce
from sandbox.sandboxsdk import environments
from sandbox.projects.tank.load_resources.resources import AMMO_FILE


class GetMarketLogsArc(sdk2.Task):

    class Parameters(sdk2.Parameters):
        yql_query = sdk2.parameters.String(
            'YQL query',
            default='SELECT market_sku FROM hahn.`home/market/testing/indexer/stratocaster/generations/blue/buybox/recent` LIMIT 100'
        )
        yql_token_name = sdk2.parameters.String('YQL token name', default='YQL_TOKEN')

    class Requirements(sdk2.Requirements):
        environments = (environments.PipEnvironment('yql', use_wheel=True),
                        environments.PipEnvironment('yandex-yt'))
        disk_space = 1024 * 5

    def on_execute(self):
        import yql.api.v1.client
        yql_token = sdk2.Vault.data(self.Parameters.yql_token_name)

        with yql.api.v1.client.YqlClient(token=yql_token) as yql_client:
            query = yql_client.query(self.Parameters.yql_query, syntax_version=1)
            query.run()
            # if not query.is_success:
            #     raise ce.TaskError('YQL request failed: ' + '; '.join(str(error) for error in query.results.errors))

            result = ''
            for table in query.get_results():
                table.fetch_full_data()
                result = '\n'.join([str(row[0]) for row in table.rows])
            logging.debug('Result is %s', result)

            if result:
                resource_data = sdk2.ResourceData(
                    AMMO_FILE(self, 'Sku list', 'sku_list', ammo_label='market_frontend_sku_list'))
                resource_data.path.write_bytes(result)
                resource_data.ready()
