# -*- coding: utf-8 -*-
import re
import random
import Cookie
import logging
# noinspection PyCompatibility
from urlparse import urlparse
from urllib import quote_plus


class MarketFrontAmmoGeneratorArc(object):

    def __init__(self, start_parameters):
        self.entry = {'cookie': Cookie.BaseCookie(), 'case': ''}
        self.log_line = []
        self.session = {}
        self.headers = {}
        self.params = start_parameters
        self.sku_urls_re = [
            re.compile(r'^/product(?:--.+?)?/(\d+)'),
            re.compile(r'\?.*skuId=(\d+)'),
            re.compile(r'^/product/.*/(\d+)')
        ]

    def get_sku_pattern(self, uri):
        for regexp in self.sku_urls_re:
            if regexp.match(uri):
                return regexp
        return None

    def is_pokupki_vhost(self):
        return 'pokupki.' in self.params['vhost']

    @staticmethod
    def junk_filter(entry):
        """ returns bool.
        Logic is simple: should we use this entry or not.
        Default is False plus some legacy code here"""

        parsed_url = urlparse(entry[3])

        if not parsed_url.path.endswith((
                '.gif', '.jpg', '.css', '.js', '.svg', '.jpeg', '.txt', '.png', '/ping', '.image', '.woff', '.eot'
        )):
            try:
                parsed_url.path.index('.js?') or parsed_url.path.index('.css?')
            except ValueError:
                return True

        return False

    def prepare_case_header(self):
        """ Makes ammo tag from page_id if exists, otherwise generate it from url """

        def case_generator(page_id):
            """ Generates ammo tag for each url """

            try:
                case_req = re.sub(r'/\d+/', '/{ID}/', page_id)
                case_req = re.sub(r'/\d{3,}', '/{ID}', case_req)
                case_req = re.sub(r'/\d.xml', '/{ID}.xml', case_req)

                # ЧПУ, которые необходимо нормализовывать
                # примеры:
                # /articles/kak-vybrat-chto-to
                # /product--artceram-jazz-jzl004/12352797
                # /search--detskie-igrovye-domiki-i-palatki?hid=10683242
                case_req = re.sub(r'^/articles/[-a-zA-Z0-9]+', '/articles', case_req)
                for user_friendly_part in ['product', 'search', 'catalog']:
                    case_req = re.sub(r'^/' + user_friendly_part + '-[-a-zA-Z0-9]+', '/' + user_friendly_part, case_req)

                case = re.split('[?&]', case_req)[0][:75]
                case = re.sub(r'/$', '', case)
            except Exception as exc:
                logging.debug('Exception when generating case: %s. Url %s', exc, page_id)
                case = 'unknown'

            return case

        if self.log_line[6] and self.log_line[6] != '-':
            self.entry['case'] = self.log_line[6]
        else:
            self.entry['case'] = case_generator(self.log_line[4])

    def prepare_log_headers(self, cookies):
        self.headers = 'Host: ' + self.params['vhost'] + '\r\n' + \
                       'Connection: close' + '\r\n' + \
                       'User-Agent: ' + self.log_line[5] + '\r\n' + \
                       'sk: 4d4a9485a03224c7347cd0cb74bd1712'

        if self.params['x_real_ip']:
            self.headers += '\r\nX-Real-IP: ' + self.log_line[1]
        if cookies:
            some_session = random.choice(cookies)
            self.entry['cookie']['Sessionid'] = some_session['session']
            self.entry['cookie']['sessionid2'] = some_session['ssl_session']
            if self.is_pokupki_vhost():
                # Добавляем mda-куку, чтобы на маркетплейсе Беру не срабатывал МДА-редирект
                # https://github.yandex-team.ru/nodules/user/blob/master/components/auth/index.js#L435
                self.entry['cookie']['mda'] = '0'
        self.headers += '\r\n' + 'Cookie: ' + self.entry['cookie'].output(header='', sep=';')

    def make_ammo(self):
        """ Generate ammo """

        self.log_line[3].rstrip()
        try:
            uri = self.log_line[3]
        except KeyError:
            logging.warning('Can\'t create ammo with log line %s', self.log_line)
            return

        # SKU for pokupki
        if self.is_pokupki_vhost():
            pattern = self.get_sku_pattern(uri)
            if pattern:
                skus = self.params['sku_list']
                sku = random.choice(skus).rstrip()
                original_sku = pattern.match(uri).group(1)
                uri = uri.replace(original_sku, sku)

        # GET/POST w/o entity body
        if not self.entry.get('body'):
            req = '{method} {uri} HTTP/1.0\r\n{headers}\r\n\r\n'.format(
                method=self.log_line[2],
                uri=uri,
                headers=self.headers
            )
        # POST with entity body
        else:
            req = '{method} {uri} HTTP/1.0\r\n{headers}\r\nContent-Length: {length}\r\n\r\n{body}\r\n'.format(
                method=self.log_line[2],
                uri=uri,
                headers=self.headers,
                length=len(self.entry['body']),
                body=self.entry['body']
            )
        # Phantom ammo template, with tag and chunk length
        return '{chunk_len} {tag}\n{req}'.format(
            chunk_len=len(req),
            tag=self.entry['case'],
            req=req
        )
