# coding=utf-8

import os.path
import os

from sandbox import sdk2
import sandbox.common.types.misc as ctm

from sandbox.projects.market.frontarc.helpers.MetatronEnvArc import MetatronEnvArc
from sandbox.projects.market.frontarc.helpers.sandbox_helpers import rich_check_call
from sandbox.projects.market.frontarc.helpers.ubuntu import create_ubuntu_selector, setup_container
from sandbox.projects.market.frontarc.helpers.node import create_node_selector
from sandbox.projects.market.frontarc.helpers.ArcDefaultParameters import ArcDefaultParameters
from sandbox.projects.market.frontarc.helpers.arc_base import MarketFrontArcBase


class MarketFrontSimpleBashArc(sdk2.Task, MarketFrontArcBase):
    """
    Таска для выполнения проектных скриптов в СБ
    """

    APP_SRC_PATH = ''

    class Parameters(sdk2.Task.Parameters):
        ubuntu_version = create_ubuntu_selector()
        node_version = create_node_selector()
        arc_params = ArcDefaultParameters()

        app_src_dir = sdk2.parameters.String("Кастомный путь корня приложения внутри репозитория")
        execution_command = sdk2.parameters.String("Команда для выполнения")
        check_env = sdk2.parameters.Dict("Переменные окружения для запуска проверки")
        vault_env = sdk2.parameters.Dict("Добавить значения из Vault в переменные окружения, ключ - переменная окружения, значение - owner:key")

    class Requirements(sdk2.Task.Requirements):
        dns = ctm.DnsType.DNS64

    def on_enqueue(self):
        super(MarketFrontSimpleBashArc, self).on_enqueue()
        setup_container(self)

    def on_prepare(self):
        self.arc_mount()
        self.arc_checkout_default()
        self._prepare_dirs()

    def on_finish(self, prev_status, status):
        super(MarketFrontSimpleBashArc, self).on_finish(prev_status, status)
        self.arc_unmount()

    def on_wait(self, prev_status, status):
        super(MarketFrontSimpleBashArc, self).on_wait(prev_status, status)
        self.arc_unmount()

    def on_execute(self):
        super(MarketFrontSimpleBashArc, self).on_execute()

        with MetatronEnvArc(self, nodejs_version=self.Parameters.node_version):
            self._run_build()

    def _run_build(self):
        rich_check_call(
            ["bash", "-c", self.Parameters.execution_command],
            self, "execution_command", cwd=self.APP_SRC_PATH, env=self.check_env
        )

    def _prepare_dirs(self):
        self.root_dir = str(self.path())
        self.APP_SRC_PATH = os.path.join(self.arcadia, self.Parameters.root_path)

        if self.Parameters.app_src_dir:
            self.APP_SRC_PATH = os.path.join(self.APP_SRC_PATH, self.Parameters.app_src_dir)

    @property
    def check_env(self):
        env = os.environ.copy()
        if self.Parameters.check_env:
            env.update(self.Parameters.check_env)
        if self.Parameters.vault_env:
            env.update(dict(map(lambda kv: (kv[0], sdk2.Vault.data(*kv[1].split(':'))), self.Parameters.vault_env.items())))
        return env
