# coding=utf-8

import os.path
import os

from sandbox import sdk2
import sandbox.common.types.misc as ctm
from sandbox.projects.market.resources import MARKET_AUTOTEST_REPORT
from sandbox.projects.market.front.resources import MarketCIReport
from sandbox.projects.market.frontarc.helpers.MetatronEnvArc import MetatronEnvArc
from sandbox.projects.market.frontarc.helpers.ubuntu import create_ubuntu_selector, setup_container
from sandbox.projects.market.frontarc.helpers.node import create_node_selector
from sandbox.projects.market.frontarc.helpers.sandbox_helpers import get_resource_http_proxy_link
from sandbox.projects.market.frontarc.helpers.ArcDefaultParameters import ArcDefaultParameters
from sandbox.projects.market.frontarc.helpers.arc_base import MarketFrontArcBase


class MarketFrontSimpleBashSaveHtmlReportArc(sdk2.Task, MarketFrontArcBase):
    """
    Таска для выполнения проектных скриптов в СБ c генерацией Html  отчёта
    """

    APP_SRC_PATH = ''

    class Parameters(sdk2.Task.Parameters):
        ubuntu_version = create_ubuntu_selector()
        node_version = create_node_selector()

        arc_params = ArcDefaultParameters()

        app_src_dir = sdk2.parameters.String("Кастомный путь корня приложения внутри репозитория")

        screen_pack_url = sdk2.parameters.String(
            'Хост стенда эталонов',
            description='При обновлении или поиске ресурса с эталонами скриншотов'
                        ' можно изменить адрес хоста, которому он соответствует'
        )
        execution_command = sdk2.parameters.String("Команда для выполнения")
        report_dir = sdk2.parameters.String("Report dir", default_value="html_reports")
        report_file_name = sdk2.parameters.String("Report file name", default_value="index.html")
        check_env = sdk2.parameters.Dict("Переменные окружения для запуска проверки")
        vault_env = sdk2.parameters.Dict("Добавить значения из Vault в переменные окружения, ключ - переменная окружения, значение - owner:key")

    class Requirements(sdk2.Task.Requirements):
        dns = ctm.DnsType.DNS64

    @property
    def check_env(self):
        env = os.environ.copy()
        if self.Parameters.check_env:
            env.update(self.Parameters.check_env)
        if self.Parameters.vault_env:
            env.update(dict(map(lambda kv: (kv[0], sdk2.Vault.data(*kv[1].split(':'))), self.Parameters.vault_env.items())))
        return env

    def _prepare_dirs(self):
        self.root_dir = str(self.path())
        self.APP_SRC_PATH = os.path.join(self.arcadia, self.Parameters.root_path)

        if self.Parameters.app_src_dir:
            self.APP_SRC_PATH = os.path.join(self.APP_SRC_PATH, self.Parameters.app_src_dir)

    def on_enqueue(self):
        super(MarketFrontSimpleBashSaveHtmlReportArc, self).on_enqueue()
        setup_container(self)

    def _run_build(self):
        return

    def on_prepare(self):
        self.arc_mount()
        self.arc_checkout_default()
        self._prepare_dirs()

    def on_execute(self):
        with MetatronEnvArc(self, nodejs_version=self.Parameters.node_version):
            self._run_build()

    @property
    def html_report_path(self):
        return os.path.join(self.APP_SRC_PATH, self.Parameters.report_dir, self.Parameters.report_file_name)

    def _create_html_report_resource(self, report_path, **params):
        target_report_dir = os.path.join(self.root_dir, self.Parameters.report_dir)

        sdk2.helpers.subprocess.check_call(['mv', report_path, self.root_dir])

        if params:
            report_res = MARKET_AUTOTEST_REPORT(self, "Screenshot report", target_report_dir, **params)
        else:
            report_res = MarketCIReport(self, "Report", target_report_dir)

        report_res_data = sdk2.ResourceData(report_res)
        report_res_data.ready()

        return report_res

    def _get_report(self, **params):
        if self.html_report_path is not None:
            res = self._create_html_report_resource(os.path.dirname(self.html_report_path), **params)
            http_report_url = '{}/{}'.format(get_resource_http_proxy_link(res),
                                                os.path.basename(self.html_report_path))
            self.set_info(
                "Отчёт: <a href=\"{url}\">{url}</a>".format(url=http_report_url),
                do_escape=False
            )

            self.report_url = http_report_url
        else:
            raise ValueError("Report not found by providing path. Set correct report dir and filename")
