# coding=utf-8

import logging

from sandbox import sdk2

from sandbox.projects.market.front.resources.yammy_resources import MarketFrontYammyBuildArtefact
from sandbox.projects.market.frontarc.MarketFrontYammyBaseArc import MarketFrontYammyBaseArc
from sandbox.projects.market.frontarc.MarketFrontYammyBuildPackageArc import MarketFrontYammyBuildPackageArc


class MarketFrontYammyBuildAllArc(MarketFrontYammyBaseArc):
    """
    Таск сборки пакетов
    """

    prebuilt = None

    class Parameters(MarketFrontYammyBaseArc.Parameters):
        MarketFrontYammyBaseArc.Parameters.description(default="Build all changed packages")

        with MarketFrontYammyBaseArc.Parameters.yammy() as yammy:
            yammy_build_meta = MarketFrontYammyBaseArc.Parameters.yammy_build_meta(required=True)
            yammy_prebuilt = MarketFrontYammyBaseArc.Parameters.yammy_prebuilt(required=True)

        with sdk2.parameters.Output:
            build = sdk2.parameters.Resource(
                "Результат сборки",
                resource_type=MarketFrontYammyBuildArtefact
            )

    def on_enqueue(self):
        super(MarketFrontYammyBuildAllArc, self).on_enqueue()
        self.prepend_tags('build', 'build-all')

    def bootstrap(self):
        if self.Parameters.yammy_prebuilt.__attrs__['stage'] == 'build':
            self.prebuilt = self.Parameters.yammy_prebuilt
            return

        resource = self.find_build_layer(
            stage='build',
            commit=self.head_commit,
            build=self.build_meta['digest']
        )

        if resource:
            self.prebuilt = resource
            return

        if not self.Context.tasks_ready:
            tasks = self._create_tasks()

            if len(tasks):
                self.wait_tasks(tasks.values())
            else:
                # FIXME: научиться менять ttl у готовых ресурсов
                self.prebuilt = self.Parameters.yammy_prebuilt
                return

        self.Context.tasks_ready = True

        super(MarketFrontYammyBuildAllArc, self).bootstrap()

        self._install_packages()

    def _create_tasks(self):
        with self.memoize_stage.create_tasks(max_runs=1):
            tasks = dict()

            for params in self.build_meta["build"]:
                wait_tasks = dict()
                wait_artefacts = dict()

                for dependency in params["dependsOn"]:
                    wait_tasks[dependency["task"]] = tasks[dependency["task"]]
                    wait_artefacts[dependency["task"]] = ",".join(dependency["artefacts"])

                tasks[params["name"]] = self._create_task(
                    params["name"], params["packages"], wait_tasks, wait_artefacts
                )

            self.Context.tasks = tasks

        return self.Context.tasks

    def _create_task(self, name, packages, wait_tasks, wait_artifacts):
        logging.info("Creating task {} for built packages: {}".format(name, packages))

        task = MarketFrontYammyBuildPackageArc(
            self,

            yammy_packages=packages,
            yammy_wait_builds=wait_tasks,
            yammy_wait_artefacts=wait_artifacts,

            **dict(
                self.Parameters,
                description="Build packages: {}".format(name),
                task_description="",
            )
        )

        with self.timer("build:{}:enqueue".format(task.id)):
            task.enqueue()

        return task.id

    def _install_packages(self):
        logging.info('Installing build artefacts')

        for (name, taks_id) in self.Context.tasks.items():
            task = sdk2.Task[taks_id]

            logging.debug('Installing {}:{} artefacts: {}'.format(name, taks_id, task.Parameters.build_results))

            for (artefact_name, artefact_id) in task.Parameters.build_results.items():
                self.install_package_artefact(artefact_name, artefact_id)

    def run_task(self):
        if self.prebuilt:
            self.Parameters.build = self.prebuilt
        else:
            self.create_build_meta()
            self.publish_prebuilt("build")
