# coding=utf-8
import logging

from sandbox.projects.market.frontarc.MarketFrontYammyBaseArc import MarketFrontYammyBaseArc
from sandbox.projects.market.frontarc.helpers.ArcanumApi import CheckStatus
from sandbox.projects.market.frontarc.helpers.yammy.arc_helpers import YammyStatusDescriptionArc

class MarketFrontYammyEvergreenArc(MarketFrontYammyBaseArc):
    """
    Унифицированная таска для запуска yammy-based сценариев в монорепе
    """

    class Parameters(MarketFrontYammyBaseArc.Parameters):
        MarketFrontYammyBaseArc.Parameters.description(default_value="yammy evergreen cube")

        # FIXME: раскоментировать после https://st.yandex-team.ru/DEVTOOLSSUPPORT-7686
        # with MarketFrontYammyBaseArc.Parameters.yammy() as yammy:
        #     yammy_prebuilt = None

    def on_enqueue(self):
        super(MarketFrontYammyEvergreenArc, self).on_enqueue()
        self.prepend_tags('evergreen')

    def update_plan(self):
        if not self.Parameters.commit_hash or not self.Parameters.task_description:
            return

        logging.info("Setting arcanum statuses for planned tasks")

        for type in ('2.0 Test bootstrap', '2.1 Test build'):
            self.update_status(CheckStatus.success, YammyStatusDescriptionArc.skipped, type)
        
        for (stage, stage_tests) in self.build_meta["test"].items():
            for (package, test_list) in stage_tests.items():
                for test_config in test_list:
                    type = self.package_task_context(package, "test:{}".format(stage), test_config)
                    self.update_status(CheckStatus.success, YammyStatusDescriptionArc.skipped, type)
        
        for (stage, stage_tests) in self.build_meta["skipped"].items():
            for (package, test_list) in stage_tests.items():
                for test_config in test_list:
                    type = self.package_task_context(package, "test:{}".format(stage), test_config)
                    self.update_status(CheckStatus.success, YammyStatusDescriptionArc.skipped, type)

    def bootstrap(self):
        pass

    def run_task(self):
        self.update_plan()
