# coding=utf-8

from sandbox import sdk2

from sandbox.projects.market.frontarc.MarketFrontYammyPackageTaskArc import MarketFrontYammyPackageTaskArc
from sandbox.projects.market.frontarc.helpers.ArcanumApi import CheckStatus


class MarketFrontYammyPublishNpmArc(MarketFrontYammyPackageTaskArc):
    """
    Таск публикации пакета в npm
    """

    alias = "publish"

    class Parameters(MarketFrontYammyPackageTaskArc.Parameters):
        with sdk2.parameters.Output:
            result = sdk2.parameters.String("Опубликованная версия")

    def update_status(self, state, description, type=None, url=None):
        if state in (CheckStatus.error, CheckStatus.failure):
            super(MarketFrontYammyPublishNpmArc, self).update_status(state, description, type=None, url=None)

    def on_enqueue(self):
        self.prepend_tags('publish-npm')
        super(MarketFrontYammyPublishNpmArc, self).on_enqueue()

    def run_task(self):
        (stdout, error) = self.run_command()

        if error:
            raise error

        with self.timer("result"):
            self.Parameters.result = stdout
