# coding=utf-8

import os
from sandbox import sdk2
from sandbox.projects.market.frontarc.helpers.sandbox_helpers import rich_check_call
from sandbox.projects.market.frontarc.MarketFrontYammyPackageTaskArc import MarketFrontYammyPackageTaskArc
from sandbox.projects.common.nanny import nanny


class MarketFrontYammyPublishResourceArc(nanny.ReleaseToNannyTask2, MarketFrontYammyPackageTaskArc):
    """
    Таск публикации пакета в npm
    """

    alias = "publish"

    class Parameters(MarketFrontYammyPackageTaskArc.Parameters):
        with sdk2.parameters.Group("Публикация") as publish:
            resource_type = sdk2.parameters.String('Класс публикуемого ресурса', required=True)

        with sdk2.parameters.Output:
            result = sdk2.parameters.Resource("Опубликованный ресурс")

    def setup_env(self):
        super(MarketFrontYammyPublishResourceArc, self).setup_env()
        os.environ['DIST_DIR'] = self.output_dir

    def on_enqueue(self):
        self.prepend_tags('publish-resource')
        super(MarketFrontYammyPublishResourceArc, self).on_enqueue()

    def run_task(self):
        (stdout, error) = self.run_command()

        if error:
            raise error

        res = sdk2.Resource[self.Parameters.resource_type](
            self,
            "Publish artefact {} for {}".format(self.Parameters.yammy_command_title, self.Parameters.yammy_package),
            self.publish_path('{}.tar.gz'.format(self.Parameters.yammy_command_name)),
            commit=self.head_commit,
            head=self.head_ref,
            artefact=self.Parameters.yammy_command_name,
            package=self.Parameters.yammy_package,
        )

        data = sdk2.ResourceData(res)

        with self.timer("result:pack"):
            rich_check_call([
                "tar", "-czvf",
                self.publish_path('{}.tar.gz'.format(self.Parameters.yammy_command_name)),
                './'
            ], self, "resource.pack", cwd=self.output_dir)

        with self.timer("result:ready"):
            data.ready()

        with self.timer("result"):
            self.Parameters.result = res
